/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import einstein.subtle_effects.client.model.entity.EinsteinSolarSystemModel;
import einstein.subtle_effects.client.model.entity.PartyHatModel;
import einstein.subtle_effects.client.model.particle.SplashParticleModel;
import einstein.subtle_effects.client.renderer.entity.EinsteinSolarSystemLayer;
import einstein.subtle_effects.client.renderer.entity.PartyHatLayer;
import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.init.ModAnimalFedEffectSettings;
import einstein.subtle_effects.init.ModBlockTickers;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModDamageListeners;
import einstein.subtle_effects.init.ModEntityTickers;
import einstein.subtle_effects.init.ModParticleGroups;
import einstein.subtle_effects.init.ModParticleLayers;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.init.ModPayloads;
import einstein.subtle_effects.init.ModPipelines;
import einstein.subtle_effects.init.ModRenderTypes;
import einstein.subtle_effects.init.ModSpriteSets;
import einstein.subtle_effects.ticking.GeyserManager;
import einstein.subtle_effects.ticking.biome_particles.BiomeParticleManager;
import einstein.subtle_effects.ticking.tickers.ChestBlockEntityTicker;
import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.ticking.tickers.WaterfallTicker;
import einstein.subtle_effects.ticking.tickers.entity.EntityTickerManager;
import einstein.subtle_effects.util.Util;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_10209;
import net.minecraft.class_11890;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_3887;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_5617;
import net.minecraft.class_591;
import net.minecraft.class_7157;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class SubtleEffectsClient {
    private static boolean HAS_CLEARED = false;
    private static boolean DISPLAY_PARTICLE_COUNT = false;
    private static boolean HAS_DISPLAYED_BIRTHDAY_NOTIFICATION = false;
    public static boolean DISPLAY_PARTICLE_BOUNDING_BOXES = false;
    private static class_1937 LEVEL;

    public static void clientSetup() {
        ModConfigs.init();
        ModPipelines.init();
        ModRenderTypes.init();
        ModParticleLayers.init();
        ModPayloads.initClientHandlers();
        ModEntityTickers.init();
        ModBlockTickers.init();
        BiomeParticleManager.init();
        ModDamageListeners.init();
        ModParticleGroups.init();
        ModParticles.init();
        ModSpriteSets.init();
        ModAnimalFedEffectSettings.init();
        CompatHelper.init();
    }

    public static void clientTick(class_310 minecraft, class_1937 level) {
        class_746 player = minecraft.field_1724;
        if (level == null || player == null || LEVEL != level) {
            LEVEL = level;
            if (!HAS_CLEARED) {
                SubtleEffectsClient.clear(level);
                BiomeParticleManager.clear();
                HAS_CLEARED = true;
            }
            return;
        }
        if (minecraft.method_1493() || level.method_54719().method_54754()) {
            return;
        }
        if (!HAS_DISPLAYED_BIRTHDAY_NOTIFICATION && ModConfigs.GENERAL.enableEasterEggs && PartyHatLayer.isModBirthday(true)) {
            long years = ChronoUnit.YEARS.between(LocalDate.of(2024, Month.OCTOBER, 3), LocalDate.now());
            SubtleEffectsClient.sendSystemMsg(minecraft, (class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)"chat.subtle_effects.prefix").method_27694(style -> style.method_10977(class_124.field_1078))).method_10852(class_5244.field_41874).method_10852((class_2561)class_2561.method_43469((String)"chat.subtle_effects.anniversary.message", (Object[])new Object[]{Util.getOrdinal(years)})));
            HAS_DISPLAYED_BIRTHDAY_NOTIFICATION = true;
        }
        if (DISPLAY_PARTICLE_COUNT) {
            player.method_7353((class_2561)class_2561.method_43469((String)"ui.subtle_effects.hud.particle_count", (Object[])new Object[]{minecraft.field_1713.method_3052()}), true);
        }
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("subtle_effects");
        profiler.method_15396("biome_particles");
        BiomeParticleManager.tickBiomeParticles(level, (class_1657)player);
        profiler.method_15407();
        profiler.method_15396("tickers");
        TickerManager.tick();
        profiler.method_15407();
        HAS_CLEARED = false;
        profiler.method_15407();
    }

    public static Map<class_5601, Supplier<class_5607>> registerModelLayers() {
        HashMap<class_5601, Supplier<class_5607>> layers = new HashMap<class_5601, Supplier<class_5607>>();
        layers.put(EinsteinSolarSystemModel.MODEL_LAYER, EinsteinSolarSystemModel::createLayer);
        layers.put(PartyHatModel.MODEL_LAYER, PartyHatModel::createLayer);
        layers.put(SplashParticleModel.MODEL_LAYER, SplashParticleModel::createLayer);
        return layers;
    }

    public static <T extends class_11890> List<class_3887<class_10055, class_591>> registerPlayerRenderLayers(class_1007<T> renderer, class_5617.class_5618 context) {
        ArrayList<class_3887<class_10055, class_591>> renderLayers = new ArrayList<class_3887<class_10055, class_591>>();
        renderLayers.add(new EinsteinSolarSystemLayer(renderer, context));
        if (PartyHatLayer.isModBirthday(false)) {
            renderLayers.add(new PartyHatLayer(renderer, context));
        }
        return renderLayers;
    }

    public static <T extends class_2172> void registerClientCommands(CommandDispatcher<T> dispatcher, class_7157 buildContext) {
        class_310 minecraft = class_310.method_1551();
        LiteralArgumentBuilder particlesClear = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"clear").executes(context -> {
            minecraft.field_1713.method_48015();
            SubtleEffectsClient.sendSystemMsg(minecraft, (class_2561)SubtleEffectsClient.getMsgTranslation("subtle_effects.particles.clear.success"));
            return 1;
        });
        RequiredArgumentBuilder particlesCountEnabled = (RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> SubtleEffectsClient.toggleParticleCount(minecraft, BoolArgumentType.getBool((CommandContext)context, (String)"enabled")));
        LiteralArgumentBuilder particlesCount = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"count").executes(context -> SubtleEffectsClient.toggleParticleCount(minecraft, true))).then((ArgumentBuilder)particlesCountEnabled);
        RequiredArgumentBuilder particlesBoundingBoxesEnabled = (RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> SubtleEffectsClient.toggleParticleBoundingBoxes(minecraft, BoolArgumentType.getBool((CommandContext)context, (String)"enabled")));
        LiteralArgumentBuilder particlesBoundingBoxes = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"display_bounding_boxes").executes(context -> SubtleEffectsClient.toggleParticleBoundingBoxes(minecraft, true))).then((ArgumentBuilder)particlesBoundingBoxesEnabled);
        LiteralArgumentBuilder particles = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"particles").then((ArgumentBuilder)particlesClear)).then((ArgumentBuilder)particlesCount)).then((ArgumentBuilder)particlesBoundingBoxes);
        LiteralArgumentBuilder tickersClear = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"clear").executes(context -> {
            SubtleEffectsClient.clear((class_1937)minecraft.field_1687);
            SubtleEffectsClient.sendSystemMsg(minecraft, (class_2561)SubtleEffectsClient.getMsgTranslation("subtle_effects.tickers.clear.success"));
            return 1;
        });
        LiteralArgumentBuilder tickers = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"tickers").then((ArgumentBuilder)tickersClear);
        LiteralArgumentBuilder subtleEffects = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"subtle_effects").then((ArgumentBuilder)particles)).then((ArgumentBuilder)tickers);
        LiteralCommandNode subtleEffectsNode = dispatcher.register(subtleEffects);
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"se").redirect((CommandNode)subtleEffectsNode));
    }

    private static int toggleParticleCount(class_310 minecraft, boolean enabled) {
        DISPLAY_PARTICLE_COUNT = enabled;
        String enabledString = enabled ? "enable" : "disable";
        SubtleEffectsClient.sendSystemMsg(minecraft, (class_2561)SubtleEffectsClient.getMsgTranslation("subtle_effects.particles.count." + enabledString + ".success"));
        return 1;
    }

    private static int toggleParticleBoundingBoxes(class_310 minecraft, boolean enabled) {
        DISPLAY_PARTICLE_BOUNDING_BOXES = enabled;
        String enabledString = enabled ? "enable" : "disable";
        SubtleEffectsClient.sendSystemMsg(minecraft, (class_2561)SubtleEffectsClient.getMsgTranslation("subtle_effects.particles.display_bounding_boxes." + enabledString + ".success"));
        return 1;
    }

    private static class_5250 getMsgTranslation(String string) {
        return class_2561.method_43471((String)("commands.subtle_effects." + string));
    }

    private static void sendSystemMsg(class_310 minecraft, class_2561 component) {
        minecraft.field_1705.method_1743().method_1812(component);
    }

    public static void clear(@Nullable class_1937 level) {
        TickerManager.clear();
        EntityTickerManager.clear(level);
        GeyserManager.ACTIVE_GEYSERS.clear();
        GeyserManager.INACTIVE_GEYSERS.clear();
        WaterfallTicker.WATERFALLS.clear();
        ChestBlockEntityTicker.clear();
    }
}

