/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.ticking.tickers;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.ticking.tickers.BlockPosTicker;
import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_5819;

public class WaterfallTicker
extends BlockPosTicker {
    public static final Map<class_2338, WaterfallTicker> WATERFALLS = new HashMap<class_2338, WaterfallTicker>();
    private final class_2338 waterfallPos;
    private WaterfallData data;
    private int updateTicks;

    public WaterfallTicker(class_1937 level, class_2338 pos, class_2338 waterfallPos, WaterfallData data) {
        super(level, pos);
        this.waterfallPos = waterfallPos;
        this.data = data;
    }

    public static void trySpawn(class_1937 level, class_3610 fluidState, class_2338 pos) {
        class_2338 waterfallPos;
        WaterfallData data;
        if (!ModConfigs.ENVIRONMENT.waterfalls.waterfallsEnabled) {
            return;
        }
        if (fluidState.method_15767(class_3486.field_15517) && fluidState.method_15771() && !WATERFALLS.containsKey(pos) && !(data = WaterfallTicker.evaluateWaterfall(level, pos, waterfallPos = pos.method_10084())).equals(WaterfallData.EMPTY_WATERFALL_DATA)) {
            WaterfallTicker ticker = new WaterfallTicker(level, pos, waterfallPos, data);
            WATERFALLS.put(pos, ticker);
            TickerManager.add(ticker);
        }
    }

    @Override
    public void positionedTick() {
        class_243 flow = this.data.flow();
        WaterfallType type = this.data.type();
        int x = this.waterfallPos.method_10263();
        int y = this.waterfallPos.method_10264();
        int z = this.waterfallPos.method_10260();
        for (class_2350 direction : this.data.openSides()) {
            double zFlow;
            double xOffset;
            boolean isLarge;
            class_2350.class_2351 axis = direction.method_10166();
            boolean isX = axis == class_2350.class_2351.field_11048;
            boolean isZ = axis == class_2350.class_2351.field_11051;
            int stepX = direction.method_10148();
            int stepZ = direction.method_10165();
            boolean bl = isLarge = type == WaterfallType.LARGE;
            double d = isX ? 0.5 + 0.7 * (double)stepX : (xOffset = (double)this.random.method_43057() + (isLarge ? 0.5 * (double)MathUtil.nextSign(this.random) : 0.0));
            double zOffset = isZ ? 0.5 + 0.7 * (double)stepZ : (double)this.random.method_43057() + (isLarge ? 0.5 * (double)MathUtil.nextSign(this.random) : 0.0);
            double xFlow = isX ? flow.method_10216() : 0.0;
            double d2 = zFlow = isZ ? flow.method_10215() : 0.0;
            if (type == WaterfallType.NORMAL) {
                if (!(this.random.method_43058() < (double)((Float)ModConfigs.ENVIRONMENT.waterfalls.mediumWaterfallParticleDensity.get()).floatValue())) continue;
                this.level.method_17452((class_2394)ModParticles.WATERFALL_CLOUD.get(), ModConfigs.ENVIRONMENT.waterfalls.forceSpawnMediumWaterfallParticles, (double)x + xOffset + MathUtil.nextDouble(this.random, 0.2), (double)((float)y + 0.2f), (double)z + zOffset + MathUtil.nextDouble(this.random, 0.2), class_3532.method_15366((class_5819)this.random, (double)0.5, (double)1.0) * xFlow, 0.0, class_3532.method_15366((class_5819)this.random, (double)0.5, (double)1.0) * zFlow);
                continue;
            }
            if (type == WaterfallType.SMALL) {
                this.level.method_8406((class_2394)ModParticles.WATERFALL_DROPLET.get(), (double)x + xOffset - (isX ? 0.2 * (double)stepX : 0.0), (double)y, (double)z + zOffset - (isZ ? 0.2 * (double)stepZ : 0.0), class_3532.method_15366((class_5819)this.random, (double)0.05, (double)0.15) * (xFlow == 0.0 ? 0.5 * (double)stepX : (double)(xFlow < 0.0 ? -1 : 1)), class_3532.method_15366((class_5819)this.random, (double)0.05, (double)0.1), class_3532.method_15366((class_5819)this.random, (double)0.05, (double)0.15) * (zFlow == 0.0 ? 0.5 * (double)stepZ : (double)(zFlow < 0.0 ? -1 : 1)));
                continue;
            }
            if (!isLarge) continue;
            boolean forceSpawn = ModConfigs.ENVIRONMENT.waterfalls.forceSpawnLargeWaterfallParticles;
            for (int i = 0; i < 6; ++i) {
                if (!(this.random.method_43058() < (double)((Float)ModConfigs.ENVIRONMENT.waterfalls.largeWaterfallParticleDensity.get()).floatValue())) continue;
                this.level.method_17452((class_2394)ModParticles.WATERFALL_CLOUD.get(), forceSpawn, (double)x + xOffset + MathUtil.nextDouble(this.random, 0.3) * (double)stepX, (double)y + MathUtil.nextDouble(this.random, 2.0) + (double)0.2f, (double)z + zOffset + MathUtil.nextDouble(this.random, 0.3) * (double)stepZ, class_3532.method_15366((class_5819)this.random, (double)0.5, (double)1.0) * xFlow, 0.0, class_3532.method_15366((class_5819)this.random, (double)0.5, (double)1.0) * zFlow);
            }
            if (this.random.method_43048(3) != 0 || !(this.random.method_43058() < (double)((Float)ModConfigs.ENVIRONMENT.waterfalls.largeWaterfallParticleDensity.get()).floatValue())) continue;
            this.level.method_17452((class_2394)ModParticles.WATERFALL_MIST.get(), forceSpawn, (double)x + xOffset, (double)(y + 1), (double)z + zOffset, class_3532.method_15366((class_5819)this.random, (double)0.5, (double)1.0) * (xFlow * 0.5), class_3532.method_15366((class_5819)this.random, (double)0.3, (double)0.7), class_3532.method_15366((class_5819)this.random, (double)0.5, (double)1.0) * (zFlow * 0.5));
        }
        if (this.updateTicks++ >= (Integer)ModConfigs.ENVIRONMENT.waterfalls.waterfallUpdateFrequency.get()) {
            WaterfallData newData = WaterfallTicker.evaluateWaterfall(this.level, this.pos, this.waterfallPos);
            if (newData.equals(WaterfallData.EMPTY_WATERFALL_DATA)) {
                this.remove();
                return;
            }
            this.data = newData;
            this.updateTicks = 0;
        }
    }

    @Override
    public void remove() {
        super.remove();
        WATERFALLS.remove(this.pos);
    }

    @Override
    protected boolean shouldCheckDistance() {
        WaterfallType type = this.data.type();
        if (type == WaterfallType.NORMAL && ModConfigs.ENVIRONMENT.waterfalls.forceSpawnMediumWaterfallParticles) {
            return false;
        }
        return type != WaterfallType.LARGE || !ModConfigs.ENVIRONMENT.waterfalls.forceSpawnLargeWaterfallParticles;
    }

    private static WaterfallData evaluateWaterfall(class_1937 level, class_2338 lakePos, class_2338 waterfallPos) {
        class_3610 lakeFluidState;
        if (!ModConfigs.ENVIRONMENT.waterfalls.waterfallsEnabled || !Util.isChunkLoaded(level, waterfallPos.method_10263(), waterfallPos.method_10260())) {
            return WaterfallData.EMPTY_WATERFALL_DATA;
        }
        class_3610 waterfallState = level.method_8316(waterfallPos);
        class_3611 waterfallFluid = waterfallState.method_15772();
        if (waterfallFluid.method_15780((lakeFluidState = level.method_8316(lakePos)).method_15772()) && lakeFluidState.method_15771() && !level.method_8320(waterfallPos).method_27852(class_2246.field_10422)) {
            ArrayList<class_2350> openSides = new ArrayList<class_2350>();
            for (class_2350 waterfallDirection : class_2350.class_2353.field_11062) {
                class_2338 openSidePos = waterfallPos.method_10093(waterfallDirection);
                if (!level.method_8316(openSidePos).method_15769() || !level.method_8320(openSidePos).method_26220((class_1922)level, openSidePos).method_20538(waterfallDirection.method_10153()).method_1110() || !level.method_8316(openSidePos).method_15769()) continue;
                boolean notSurrounded = false;
                for (class_2350 relativeDirection : class_2350.class_2353.field_11062) {
                    class_2338 relativePos = openSidePos.method_10093(relativeDirection);
                    if (Util.isSolidOrNotEmpty(level, relativePos)) continue;
                    notSurrounded = true;
                    break;
                }
                if (!notSurrounded) continue;
                openSides.add(waterfallDirection);
            }
            if (!openSides.isEmpty()) {
                boolean surroundedByWater = false;
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && z == 0 || !waterfallFluid.method_15780(level.method_8316(lakePos.method_10069(x, 0, z)).method_15772())) continue;
                        surroundedByWater = true;
                    }
                }
                if (surroundedByWater) {
                    int distance = 0;
                    for (int i = 19; i > -1; --i) {
                        class_2338 abovePos = waterfallPos.method_10086(20 - i);
                        class_3610 aboveFluidState = level.method_8316(abovePos);
                        if (!waterfallFluid.method_15780(aboveFluidState.method_15772())) continue;
                        ++distance;
                    }
                    boolean canBeLarge = false;
                    WaterfallType type = WaterfallType.NORMAL;
                    if (distance >= 0 && distance <= (Integer)ModConfigs.ENVIRONMENT.waterfalls.mediumWaterfallHeightThreshold.get() - 2) {
                        type = ModConfigs.ENVIRONMENT.waterfalls.smallWaterfallsEnabled ? WaterfallType.SMALL : null;
                    } else if (ModConfigs.ENVIRONMENT.waterfalls.largeWaterfallsEnabled && distance > (Integer)ModConfigs.ENVIRONMENT.waterfalls.largeWaterfallHeightThreshold.get() - 2) {
                        int size = 0;
                        canBeLarge = true;
                        for (class_2350 direction : class_2350.class_2353.field_11062) {
                            class_2338 relativePos = lakePos.method_10093(direction);
                            WaterfallTicker relativeTicker = WATERFALLS.get(relativePos);
                            if (relativeTicker == null) {
                                relativePos = relativePos.method_10093(direction.method_10170());
                                relativeTicker = WATERFALLS.get(relativePos);
                            }
                            if (relativeTicker == null || !relativeTicker.data.canBeLarge()) continue;
                            if (relativeTicker.data.type() == WaterfallType.LARGE) {
                                type = WaterfallType.LARGE;
                                break;
                            }
                            ++size;
                            class_2338 neighborPos = relativePos.method_10093(direction);
                            WaterfallTicker neighborTicker = WATERFALLS.get(neighborPos);
                            if (neighborTicker == null) {
                                neighborPos = neighborPos.method_10093(direction.method_10170());
                                neighborTicker = WATERFALLS.get(neighborPos);
                            }
                            if (neighborTicker == null || !neighborTicker.data.canBeLarge()) continue;
                            ++size;
                            break;
                        }
                        if (size >= 2) {
                            type = WaterfallType.LARGE;
                        }
                    }
                    if (type == null) {
                        return WaterfallData.EMPTY_WATERFALL_DATA;
                    }
                    class_243 flow = waterfallState.method_15758((class_1922)level, waterfallPos);
                    if (flow.equals((Object)class_243.field_1353)) {
                        for (class_2350 openSide : openSides) {
                            flow = flow.method_1031((double)openSide.method_10148(), 0.0, (double)openSide.method_10165());
                        }
                    }
                    return new WaterfallData(type, canBeLarge, openSides, flow);
                }
            }
        }
        return WaterfallData.EMPTY_WATERFALL_DATA;
    }

    public record WaterfallData(WaterfallType type, boolean canBeLarge, List<class_2350> openSides, class_243 flow) {
        public static final WaterfallData EMPTY_WATERFALL_DATA = new WaterfallData(WaterfallType.NORMAL, false, new ArrayList<class_2350>(), class_243.field_1353);
    }

    public static enum WaterfallType {
        NORMAL,
        SMALL,
        LARGE;

    }
}

