/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.ticking.tickers.entity.sleeping;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.ticking.tickers.entity.EntityTicker;
import einstein.subtle_effects.util.Util;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_2394;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class SleepingTicker<T extends class_1309>
extends EntityTicker<T> {
    private final class_3414 snoreSound;
    private final float snoreVolume;
    private final int breathDelay;
    private final boolean doesSnore;
    private boolean firstSleepTick = true;
    private boolean isFirstBreath = true;
    private int snoreStartDelay = 0;
    private int delayTimer = 0;
    private int breatheTimer = 0;
    private int snoreTimer = 0;
    private int zCount = 0;

    public SleepingTicker(T entity) {
        this(entity, true, 60, null, 0.0f);
    }

    public SleepingTicker(T entity, boolean doesSnore, int breathDelay, class_3414 snoreSound, float snoreVolume) {
        super(entity);
        this.doesSnore = doesSnore;
        this.snoreVolume = snoreVolume;
        this.snoreSound = snoreSound;
        this.breathDelay = breathDelay;
    }

    @Override
    public void entityTick() {
        if (this.isSleeping()) {
            if (this.firstSleepTick) {
                this.snoreStartDelay = this.shouldDelay() ? 60 + this.random.method_43048(40) : 0;
                this.firstSleepTick = false;
                return;
            }
            if (this.delayTimer < this.snoreStartDelay) {
                ++this.delayTimer;
                return;
            }
            if (!this.isFirstBreath && this.breatheTimer < this.breathDelay) {
                ++this.breatheTimer;
                return;
            }
            if (this.snoreTimer >= 10) {
                if (this.doesSnore && !((class_1309)this.entity).method_5701() && this.zCount <= 0 && this.snoreSound != null) {
                    Util.playClientSound(this.entity, this.snoreSound, class_3419.field_15254, this.snoreVolume, ((class_1309)this.entity).method_6017());
                }
                this.snoreTimer = 0;
                ++this.zCount;
                if (this.particleConfigEnabled() && (!ModConfigs.ENTITIES.sleeping.displaySleepingZsOnlyWhenSnoring || this.doesSnore)) {
                    this.level.method_8406(this.getParticle(), ((class_1309)this.entity).method_23317(), ((class_1309)this.entity).method_23318() + 0.5, ((class_1309)this.entity).method_23321(), 0.0, 0.0, 0.0);
                }
                if (this.zCount >= 3) {
                    this.zCount = 0;
                    this.breatheTimer = 0;
                    this.isFirstBreath = false;
                }
            }
            if (this.snoreTimer < 10) {
                ++this.snoreTimer;
            }
            return;
        }
        this.firstSleepTick = true;
        this.isFirstBreath = true;
        this.snoreStartDelay = 0;
        this.delayTimer = 0;
        this.breatheTimer = 0;
        this.snoreTimer = 0;
        this.zCount = 0;
    }

    protected boolean isSleeping() {
        return ((class_1309)this.entity).method_6113();
    }

    protected class_2394 getParticle() {
        return (class_2394)ModParticles.SNORING.get();
    }

    protected boolean shouldDelay() {
        return true;
    }

    protected boolean particleConfigEnabled() {
        return ModConfigs.ENTITIES.sleeping.otherMobsHaveSleepingZs;
    }

    protected static boolean doesEntitySnore(class_1309 entity, double chance) {
        UUID uuid = entity.method_5667();
        return Double.parseDouble("0." + Math.abs(uuid.hashCode())) < chance;
    }
}

