/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util.mod.quilt;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.terraformersmc.modmenu.api.UpdateChannel;
import com.terraformersmc.modmenu.api.UpdateChecker;
import com.terraformersmc.modmenu.api.UpdateInfo;
import com.terraformersmc.modmenu.util.HttpUtil;
import com.terraformersmc.modmenu.util.JsonUtil;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.quiltmc.loader.api.ModContainer;
import org.quiltmc.loader.api.QuiltLoader;
import org.quiltmc.loader.api.Version;
import org.quiltmc.loader.api.VersionFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuiltLoaderUpdateChecker
implements UpdateChecker {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu/Quilt Update Checker");
    private static final URI LOADER_VERSIONS = URI.create("https://meta.quiltmc.org/v3/versions/loader");

    @Override
    public UpdateInfo checkForUpdates() {
        UpdateInfo result = null;
        try {
            result = QuiltLoaderUpdateChecker.checkForUpdates0();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            LOGGER.error("Failed Quilt Loader update check!", (Throwable)e);
        }
        return result;
    }

    private static UpdateInfo checkForUpdates0() throws IOException, InterruptedException {
        UpdateChannel preferredChannel = UpdateChannel.getUserPreference();
        HttpRequest.Builder request = HttpRequest.newBuilder().GET().uri(LOADER_VERSIONS);
        HttpResponse<String> response = HttpUtil.request(request, HttpResponse.BodyHandlers.ofString());
        int status = response.statusCode();
        if (status != 200) {
            LOGGER.warn("Quilt Meta responded with a non-200 status: {}!", (Object)status);
            return null;
        }
        Optional<String> contentType = response.headers().firstValue("Content-Type");
        if (contentType.isEmpty() || !contentType.get().contains("application/json")) {
            LOGGER.warn("Quilt Meta responded with a non-json content type, aborting loader update check!");
            return null;
        }
        JsonElement data = JsonParser.parseString((String)response.body());
        if (!data.isJsonArray()) {
            LOGGER.warn("Received invalid data from Quilt Meta, aborting loader update check!");
            return null;
        }
        Version.Semantic match = null;
        for (JsonElement child : data.getAsJsonArray()) {
            Version.Semantic parsed;
            JsonObject object;
            Optional<String> version;
            if (!child.isJsonObject() || (version = JsonUtil.getString(object = child.getAsJsonObject(), "version")).isEmpty()) continue;
            try {
                parsed = Version.Semantic.of((String)version.get());
            }
            catch (VersionFormatException e) {
                continue;
            }
            if (preferredChannel == UpdateChannel.RELEASE && !parsed.preRelease().isEmpty() || preferredChannel == UpdateChannel.BETA && !QuiltLoaderUpdateChecker.isStableOrBeta(parsed.preRelease()) || match != null && !QuiltLoaderUpdateChecker.isNewer(parsed, match)) continue;
            match = parsed;
        }
        Version.Semantic current = QuiltLoaderUpdateChecker.getCurrentVersion();
        if (match == null || !QuiltLoaderUpdateChecker.isNewer(match, current)) {
            LOGGER.debug("Quilt Loader is up to date.");
            return null;
        }
        LOGGER.debug("Quilt Loader has a matching update available!");
        return new QuiltLoaderUpdateInfo(match);
    }

    private static boolean isNewer(Version.Semantic self, Version.Semantic other) {
        return self.compareTo(other) > 0;
    }

    private static Version.Semantic getCurrentVersion() {
        return ((ModContainer)QuiltLoader.getModContainer((String)"quilt_loader").get()).metadata().version().semantic();
    }

    private static boolean isStableOrBeta(String preRelease) {
        return preRelease.isEmpty() || preRelease.startsWith("beta") || preRelease.startsWith("pre") || preRelease.startsWith("rc");
    }

    private record QuiltLoaderUpdateInfo(Version.Semantic version) implements UpdateInfo
    {
        @Override
        public boolean isUpdateAvailable() {
            return true;
        }

        @Override
        @NotNull
        public class_2561 getUpdateMessage() {
            return class_2561.method_43469((String)"modmenu.install_version", (Object[])new Object[]{this.version.raw()});
        }

        @Override
        public String getDownloadLink() {
            return "https://quiltmc.org/en/install/client";
        }

        @Override
        public UpdateChannel getUpdateChannel() {
            String preRelease = this.version.preRelease();
            if (preRelease.isEmpty()) {
                return UpdateChannel.RELEASE;
            }
            if (QuiltLoaderUpdateChecker.isStableOrBeta(preRelease)) {
                return UpdateChannel.BETA;
            }
            return UpdateChannel.ALPHA;
        }
    }
}

