/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.parent;

import net.minecraft.class_11910;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import org.joml.Matrix3x2fStack;
import team.creative.creativecore.client.gui.GuiClientControl;
import team.creative.creativecore.client.gui.GuiClientParent;
import team.creative.creativecore.common.gui.control.parent.GuiScrollXY;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.math.vec.SmoothValue;

public class GuiClientScrollXY<T extends GuiScrollXY>
extends GuiClientParent<T>
implements GuiScrollXY.GuiScrollXYDist {
    public int maxScrollX = 0;
    public SmoothValue scrolledX = new SmoothValue(200L);
    public boolean draggedX;
    public int maxScrollY = 0;
    public SmoothValue scrolledY = new SmoothValue(200L);
    public boolean draggedY;
    public int scrollbarThickness = 3;
    public ControlFormatting.ControlStyleFace scrollbarFace = ControlFormatting.ControlStyleFace.CLICKABLE;
    public boolean alternativeScrolling = false;
    protected int cachedWidth;
    protected int cachedHeight;

    public GuiClientScrollXY(T control) {
        super(control);
    }

    @Override
    public double getOffsetX() {
        return -this.scrolledX.current();
    }

    @Override
    public double getOffsetY() {
        return -this.scrolledY.current();
    }

    @Override
    protected ControlFormatting defaultFormatting() {
        return ControlFormatting.NESTED;
    }

    public void onScrolledX() {
        if (this.scrolledX.aimed() < 0.0) {
            this.scrolledX.set(0.0);
        }
        if (this.scrolledX.aimed() > (double)this.maxScrollX) {
            this.scrolledX.set(this.maxScrollX);
        }
    }

    public void onScrolledY() {
        if (this.scrolledY.aimed() < 0.0) {
            this.scrolledY.set(0.0);
        }
        if (this.scrolledY.aimed() > (double)this.maxScrollY) {
            this.scrolledY.set(this.maxScrollY);
        }
    }

    @Override
    public boolean mouseScrolled(double x, double y, double scrolled) {
        if (super.mouseScrolled(x, y, scrolled)) {
            return true;
        }
        this.scroll(scrolled);
        return true;
    }

    public void scroll(double scrolled) {
        if (this.alternativeScrolling) {
            if (class_310.method_1551().method_74187()) {
                if (this.needsScrollbarX()) {
                    this.scrolledX.set(this.scrolledX.aimed() - scrolled * 10.0);
                    this.onScrolledX();
                }
                return;
            }
            this.scrolledY.set(this.scrolledY.aimed() - scrolled * 10.0);
            this.onScrolledY();
            return;
        }
        boolean shouldScrollY = this.needsScrollbarY();
        if (shouldScrollY) {
            if (scrolled > 0.0 && this.scrolledY.aimed() == 0.0) {
                shouldScrollY = false;
            } else if (scrolled < 0.0 && this.scrolledY.aimed() == (double)this.maxScrollY) {
                shouldScrollY = false;
            }
        }
        if (shouldScrollY) {
            this.scrolledY.set(this.scrolledY.aimed() - scrolled * 10.0);
            this.onScrolledY();
            return;
        }
        this.scrolledX.set(this.scrolledX.aimed() - scrolled * 10.0);
        this.onScrolledX();
    }

    @Override
    public boolean mouseClicked(double x, double y, class_11910 info) {
        if (info.comp_4801() == 0 && (double)this.rect.getHeight() - y <= (double)this.scrollbarThickness && this.needsScrollbarX()) {
            this.playSound((class_6880.class_6883<class_3414>)class_3417.field_15015);
            this.draggedX = true;
            return true;
        }
        if (info.comp_4801() == 0 && (double)this.rect.getWidth() - x <= (double)this.scrollbarThickness && this.needsScrollbarY()) {
            this.playSound((class_6880.class_6883<class_3414>)class_3417.field_15015);
            this.draggedY = true;
            return true;
        }
        return super.mouseClicked(x, y, info);
    }

    @Override
    public void mouseMoved(double x, double y) {
        double percent;
        ControlFormatting formatting;
        GuiStyle style;
        if (this.draggedX) {
            style = this.getStyle();
            formatting = this.getControlFormatting();
            int completeWidth = this.rect.getWidth() - style.getBorder(formatting.border()) * 2;
            int scrollThingWidth = Math.max(10, Math.min(completeWidth, (int)((float)completeWidth / (float)this.cachedWidth * (float)completeWidth)));
            if (this.cachedWidth < completeWidth) {
                scrollThingWidth = completeWidth;
            }
            percent = x / (double)(completeWidth - scrollThingWidth);
            this.scrolledX.set((int)(percent * (double)this.maxScrollX));
            this.onScrolledX();
        }
        if (this.draggedY) {
            style = this.getStyle();
            formatting = this.getControlFormatting();
            int completeHeight = this.rect.getHeight() - style.getBorder(formatting.border()) * 2;
            int scrollThingHeight = Math.max(10, Math.min(completeHeight, (int)((float)completeHeight / (float)this.cachedHeight * (float)completeHeight)));
            if (this.cachedHeight < completeHeight) {
                scrollThingHeight = completeHeight;
            }
            percent = y / (double)(completeHeight - scrollThingHeight);
            this.scrolledY.set((int)(percent * (double)this.maxScrollY));
            this.onScrolledY();
        }
        super.mouseMoved(x, y);
    }

    @Override
    public void mouseReleased(double x, double y, class_11910 info) {
        super.mouseReleased(x, y, info);
        this.draggedY = false;
        this.draggedX = false;
    }

    public boolean needsScrollbarX() {
        return this.cachedWidth > this.rect.getContentWidth();
    }

    public boolean needsScrollbarY() {
        return this.cachedHeight > this.rect.getContentHeight();
    }

    @Override
    protected void renderContent(class_332 graphics, ControlFormatting formatting, int borderWidth, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        double newScroll;
        double percent;
        Matrix3x2fStack pose = graphics.method_51448();
        pose.pushMatrix();
        super.renderContent(graphics, formatting, borderWidth, controlRect, realRect, scale, mouseX, mouseY);
        pose.popMatrix();
        float controlInvScale = (float)this.scaleFactorInv();
        pose.scale(controlInvScale, controlInvScale);
        GuiClientScrollXY.scissor(graphics, realRect);
        GuiStyle style = this.getStyle();
        this.scrolledX.tick();
        if (this.needsScrollbarX()) {
            int completeWidth = this.rect.getWidth() - borderWidth * 2;
            int scrollThingWidth = Math.max(10, Math.min(completeWidth, (int)((float)completeWidth / (float)this.cachedWidth * (float)completeWidth)));
            if (this.cachedWidth < completeWidth) {
                scrollThingWidth = completeWidth;
            }
            percent = this.scrolledX.current() / (double)this.maxScrollX;
            style.get(this.scrollbarFace, false).render(graphics, (int)(percent * (double)(completeWidth - scrollThingWidth)) + borderWidth, this.rect.getHeight() - this.scrollbarThickness - borderWidth, scrollThingWidth, this.scrollbarThickness);
            this.maxScrollX = Math.max(0, this.cachedWidth - completeWidth + formatting.padding() * 2 + 1);
            newScroll = Math.clamp(this.scrolledX.aimed(), 0.0, (double)this.maxScrollX);
            if (newScroll != this.scrolledX.aimed()) {
                this.scrolledX.set(newScroll);
            }
        }
        this.scrolledY.tick();
        if (this.needsScrollbarY()) {
            int completeHeight = this.rect.getHeight() - borderWidth * 2;
            int scrollThingHeight = Math.max(10, Math.min(completeHeight, (int)((float)completeHeight / (float)this.cachedHeight * (float)completeHeight)));
            if (this.cachedHeight < completeHeight) {
                scrollThingHeight = completeHeight;
            }
            percent = this.scrolledY.current() / (double)this.maxScrollY;
            style.get(this.scrollbarFace, false).render(graphics, this.rect.getWidth() - this.scrollbarThickness - borderWidth, (int)(percent * (double)(completeHeight - scrollThingHeight)) + borderWidth, this.scrollbarThickness, scrollThingHeight);
            this.maxScrollY = Math.max(0, this.cachedHeight - completeHeight + formatting.padding() * 2 + 1);
            newScroll = Math.clamp(this.scrolledY.aimed(), 0.0, (double)this.maxScrollY);
            if (newScroll != this.scrolledY.aimed()) {
                this.scrolledY.set(newScroll);
            }
        }
        float controlScale = (float)this.scaleFactor();
        pose.scale(controlScale, controlScale);
    }

    @Override
    protected int minWidth(int availableWidth) {
        return 10;
    }

    @Override
    protected int minHeight(int width, int availableHeight) {
        return 10;
    }

    @Override
    public void flowX(int width, int preferred) {
        super.flowX(preferred, preferred);
        this.updateWidth();
    }

    protected void updateWidth() {
        int maxX = 0;
        for (GuiClientControl control : this.controls()) {
            maxX = Math.max(control.rect.getRight(), maxX);
        }
        this.cachedWidth = maxX;
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        super.flowY(this.cachedWidth, preferred, preferred);
        this.updateHeight();
    }

    protected void updateHeight() {
        int maxY = 0;
        for (GuiClientControl control : this.controls()) {
            maxY = Math.max(control.rect.getBottom(), maxY);
        }
        this.cachedHeight = maxY;
    }
}

