/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.simple;

import java.util.HexFormat;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_10799;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11910;
import net.minecraft.class_156;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.client.gui.control.GuiFocusControl;
import team.creative.creativecore.client.render.gui.CreativeGuiGraphics;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiTextUpdateEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;

public class GuiClientTextfield<T extends GuiTextfield>
extends GuiFocusControl<T>
implements GuiTextfield.GuiTextfieldDist {
    private String text = "";
    private int maxStringLength = 128;
    private String suggestion = "";
    private int frame;
    private boolean shift;
    private int lineScrollOffset;
    private int cursorPosition;
    private int selectionEnd;
    private int cachedWidth;
    private Function<String, String> modifyPaste = null;
    private final BiFunction<String, Integer, class_5481> textFormatter = (text, pos) -> class_5481.method_30747((String)text, (class_2583)class_2583.field_24360);
    private Predicate<String> validator = Objects::nonNull;

    public GuiClientTextfield(T control) {
        super(control);
    }

    @Override
    public void setFloatOnly() {
        this.validator = x -> {
            if (x.isEmpty() || x.equalsIgnoreCase("-")) {
                return true;
            }
            try {
                Float.parseFloat(x);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
    }

    @Override
    public void setNumbersIncludingNegativeOnly() {
        this.validator = x -> {
            if (x.isEmpty() || x.equalsIgnoreCase("-")) {
                return true;
            }
            try {
                Integer.parseInt(x);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
    }

    @Override
    public void setNumbersOnly() {
        this.validator = x -> {
            if (x.isEmpty()) {
                return true;
            }
            try {
                return Integer.parseInt(x) >= 0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
    }

    @Override
    public void setHexOnly() {
        this.modifyPaste = x -> x.replace("#", "");
        this.validator = x -> {
            try {
                HexFormat.fromHexDigits(x);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
    }

    @Override
    public void setText(String textIn, boolean notify, boolean keepCursor) {
        if (this.validator.test(textIn)) {
            this.text = textIn.length() > this.maxStringLength ? textIn.substring(0, this.maxStringLength) : textIn;
            if (!keepCursor) {
                this.setCursorPositionZero();
                this.setSelectionPos(this.cursorPosition);
            }
            if (notify) {
                this.onTextChanged(textIn);
            }
        }
    }

    @Override
    public String getText() {
        return this.text;
    }

    private void onTextChanged(String newText) {
        this.raiseEvent(new GuiTextUpdateEvent((GuiTextfield)this.control));
    }

    @Override
    public void setSuggestion(@Nullable String suggestion) {
        this.suggestion = suggestion;
    }

    @Override
    public void tick() {
        ++this.frame;
    }

    @Override
    protected ControlFormatting defaultFormatting() {
        return ControlFormatting.NESTED;
    }

    @Override
    protected void renderContent(class_332 graphics, int mouseX, int mouseY) {
        class_327 font = ((CreativeGuiGraphics)graphics).font();
        int j = this.cursorPosition - this.lineScrollOffset;
        int k = this.selectionEnd - this.lineScrollOffset;
        GuiStyle style = this.getStyle();
        int color = this.enabled ? style.fontColor.toInt() : style.fontColorDisabled.toInt();
        String s = font.method_27523(this.text.substring(this.lineScrollOffset), this.rect.getContentWidth());
        boolean flag = j >= 0 && j <= s.length();
        boolean flag1 = this.isFocused() && this.frame / 6 % 2 == 0 && flag;
        int yOffset = 0;
        int xOffset = 0;
        if (k > s.length()) {
            k = s.length();
        }
        if (!s.isEmpty()) {
            String s1 = flag ? s.substring(0, j) : s;
            class_5481 textFormatted = this.textFormatter.apply(s1, this.lineScrollOffset);
            graphics.method_51430(font, textFormatted, xOffset, yOffset, color, false);
            xOffset = font.method_30880(textFormatted) + 1;
        }
        boolean flag2 = this.cursorPosition < this.text.length() || this.text.length() >= this.maxStringLength;
        int k1 = xOffset;
        if (!flag) {
            k1 = j > 0 ? this.rect.getContentWidth() : 0;
        } else if (flag2) {
            k1 = xOffset - 1;
            --xOffset;
        }
        if (!s.isEmpty() && flag && j < s.length()) {
            graphics.method_51430(font, this.textFormatter.apply(s.substring(j), this.cursorPosition), xOffset, yOffset, color, false);
        }
        if (this.text.isEmpty() && !this.suggestion.isEmpty()) {
            graphics.method_25303(font, this.suggestion, k1 - 1, yOffset, -8355712);
        }
        if (flag1) {
            if (flag2) {
                graphics.method_25294(k1, yOffset - 1, k1 + 1, yOffset + 1 + 9, -3092272);
            } else {
                graphics.method_25303(font, "_", k1, yOffset, color);
            }
        }
        if (k != j) {
            int l1 = font.method_1727(s.substring(0, k));
            this.drawSelectionBox(graphics, k1, yOffset - 1, l1 - 1, yOffset + 1 + 9);
        }
    }

    private void drawSelectionBox(class_332 graphics, int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.rect.getRight()) {
            endX = this.rect.getRight();
        }
        if (startX > this.rect.getRight()) {
            startX = this.rect.getRight();
        }
        graphics.method_48196(class_10799.field_56881, startX, startY, endX, endY, -16776961);
    }

    public String getSelectedText() {
        int i = Math.min(this.cursorPosition, this.selectionEnd);
        int j = Math.max(this.cursorPosition, this.selectionEnd);
        return this.text.substring(i, j);
    }

    public void writeText(String textToWrite) {
        String s1;
        String s;
        int l;
        int i = Math.min(this.cursorPosition, this.selectionEnd);
        int j = Math.max(this.cursorPosition, this.selectionEnd);
        int k = this.maxStringLength - this.text.length() - (i - j);
        if (k < (l = (s = class_3544.method_57180((String)textToWrite)).length())) {
            s = s.substring(0, k);
            l = k;
        }
        if (this.validator.test(s1 = new StringBuilder(this.text).replace(i, j, s).toString())) {
            this.text = s1;
            this.clampCursorPosition(i + l);
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(this.text);
        }
    }

    private void delete(int p_212950_1_, class_11908 key) {
        if (key.method_74240()) {
            this.deleteWords(p_212950_1_);
        } else {
            this.deleteFromCursor(p_212950_1_);
        }
        this.onTextChanged(this.text);
    }

    public void deleteWords(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                String s;
                int k;
                int i = this.getCursorPos(num);
                int j = Math.min(i, this.cursorPosition);
                if (j != (k = Math.max(i, this.cursorPosition)) && this.validator.test(s = new StringBuilder(this.text).delete(j, k).toString())) {
                    this.text = s;
                    this.setCursorPosition(j);
                }
            }
        }
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.getCursorPosition());
    }

    private int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    private int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.getCursorPos(num));
    }

    private int getCursorPos(int p_238516_1_) {
        return class_156.method_27761((String)this.text, (int)this.cursorPosition, (int)p_238516_1_);
    }

    public void setCursorPosition(int pos) {
        this.clampCursorPosition(pos);
        if (!this.shift) {
            this.setSelectionPos(this.cursorPosition);
        }
    }

    public void clampCursorPosition(int pos) {
        this.cursorPosition = class_3532.method_15340((int)pos, (int)0, (int)this.text.length());
    }

    @Override
    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    @Override
    public boolean keyPressed(class_11908 key) {
        if (!this.canWrite()) {
            return false;
        }
        this.shift = key.method_74239();
        if (key.method_74241()) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (key.method_74242()) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            return true;
        }
        if (key.method_74243()) {
            String s = class_310.method_1551().field_1774.method_1460();
            if (this.modifyPaste != null) {
                s = this.modifyPaste.apply(s);
            }
            this.writeText(s);
            return true;
        }
        if (key.method_74244()) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            this.writeText("");
            return true;
        }
        switch (key.comp_4795()) {
            case 259: {
                this.shift = false;
                this.delete(-1, key);
                this.shift = key.method_74239();
                return true;
            }
            case 258: 
            case 260: 
            case 264: 
            case 265: 
            case 266: 
            case 267: {
                return false;
            }
            default: {
                return class_3544.method_57175((int)((char)key.comp_4795()));
            }
            case 261: {
                this.shift = false;
                this.delete(1, key);
                this.shift = key.method_74239();
                return true;
            }
            case 262: {
                if (key.method_74240()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 263: {
                if (key.method_74240()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 268: {
                this.setCursorPositionZero();
                return true;
            }
            case 269: 
        }
        this.setCursorPositionEnd();
        return true;
    }

    public boolean canWrite() {
        return this.isFocused();
    }

    @Override
    public boolean charTyped(class_11905 event) {
        if (!this.canWrite()) {
            return false;
        }
        if (class_3544.method_57175((int)event.comp_4793())) {
            this.writeText(Character.toString(event.comp_4793()));
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, class_11910 info) {
        super.mouseClicked(mouseX, mouseY, info);
        if (info.comp_4801() == 0) {
            int i = class_3532.method_15357((double)mouseX);
            class_327 fontRenderer = class_310.method_1551().field_1772;
            String s = fontRenderer.method_27523(this.text.substring(this.lineScrollOffset), this.rect.getContentWidth());
            this.shift = info.method_74239();
            this.setCursorPosition(fontRenderer.method_27523(s, i).length() + this.lineScrollOffset);
            return true;
        }
        return false;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    @Override
    protected void focusChanged() {
        if (this.isFocused()) {
            this.frame = 0;
        }
    }

    @Override
    public void flowX(int width, int preferred) {
        this.cachedWidth = width - this.getContentOffset() * 2;
    }

    @Override
    public void flowY(int width, int height, int preferred) {
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return 10;
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return 40;
    }

    public void setSelectionPos(int position) {
        int textLength = this.text.length();
        this.selectionEnd = class_3532.method_15340((int)position, (int)0, (int)textLength);
        class_327 fontRenderer = class_310.method_1551().field_1772;
        if (fontRenderer != null) {
            if (this.lineScrollOffset > textLength) {
                this.lineScrollOffset = textLength;
            }
            int j = this.cachedWidth;
            String s = fontRenderer.method_27523(this.text.substring(this.lineScrollOffset), j);
            int k = s.length() + this.lineScrollOffset;
            if (this.selectionEnd == this.lineScrollOffset) {
                this.lineScrollOffset -= fontRenderer.method_27524(this.text, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.lineScrollOffset += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - this.selectionEnd;
            }
            this.lineScrollOffset = class_3532.method_15340((int)this.lineScrollOffset, (int)0, (int)textLength);
        }
    }

    @Override
    public void setValidator(Predicate<String> validatorIn) {
        this.validator = validatorIn;
    }

    @Override
    public void setMaxStringLength(int length) {
        this.maxStringLength = length;
        if (this.text.length() > length) {
            this.text = this.text.substring(0, length);
            this.onTextChanged(this.text);
        }
    }
}

