/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.timeline;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_11910;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import org.joml.Matrix3x2fStack;
import team.creative.creativecore.client.gui.GuiClientControl;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineKey;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiClientTimelineKey<T extends GuiTimelineKey<K>, K>
extends GuiClientControl<T>
implements GuiTimelineKey.GuiTimelineKeyDist {
    public static final double DRAG_TIME = 2.0;
    private boolean selected;
    private boolean clicked;

    public GuiClientTimelineKey(T control) {
        super(control);
    }

    @Override
    public Rect createChildRect(Rect contentRect, double scale, double xOffset, double yOffset) {
        Rect temp = this.rect.rectCopy();
        temp.grow(Math.max(temp.getWidth() / 4.0, temp.getHeight() / 4.0));
        return contentRect.child(temp, scale, xOffset, yOffset);
    }

    @Override
    public boolean mouseClicked(double x, double y, class_11910 info) {
        if (!((GuiTimelineKey)this.control).modifiable) {
            return false;
        }
        if (info.comp_4801() == 0) {
            ((GuiTimelineKey)this.control).channel.select((GuiTimelineKey)this.control);
            this.playSound((class_6880.class_6883<class_3414>)class_3417.field_15015);
            this.clicked = true;
        } else if (info.comp_4801() == 1) {
            if (this.selected) {
                ((GuiTimelineKey)this.control).channel.timeline.deselect();
            }
            ((GuiTimelineKey)this.control).channel.removeKey((GuiTimelineKey)this.control);
            this.playSound(class_3417.field_14770, 0.1f, 0.6f);
        }
        return true;
    }

    @Override
    public void mouseDragged(double x, double y, class_11910 info, double dragX, double dragY, double time) {
        if (!((GuiTimelineKey)this.control).modifiable) {
            return;
        }
        if (this.clicked && time > 2.0) {
            ((GuiTimelineKey)this.control).channel.dragKey((GuiTimelineKey)this.control);
            this.clicked = false;
        }
        super.mouseDragged(x, y, info, dragX, dragY, time);
    }

    @Override
    public void mouseReleased(double x, double y, class_11910 info) {
        this.clicked = false;
    }

    @Override
    public void flowX(int width, int preferred) {
    }

    @Override
    public void flowY(int width, int height, int preferred) {
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return 6;
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return 6;
    }

    @Override
    protected ControlFormatting defaultFormatting() {
        return ControlFormatting.TRANSPARENT_NO_DISABLE;
    }

    @Override
    public void render(class_332 graphics, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        RenderSystem.getDevice().createCommandEncoder().clearDepthTexture(class_310.method_1551().method_1522().method_30278(), 1.0);
        Matrix3x2fStack pose = graphics.method_51448();
        GuiStyle style = this.getStyle();
        pose.pushMatrix();
        int width = this.rect.getWidth();
        int height = this.rect.getHeight();
        pose.translate((float)width * 0.5f, (float)height * 0.5f);
        pose.rotate(45.0f);
        pose.translate((float)width * -0.5f, (float)height * -0.5f);
        int borderWidth = style.getBorder(ControlFormatting.ControlStyleBorder.SMALL);
        style.border.render(graphics, width, height);
        StyleDisplay foreground = style.clickable;
        if (!this.enabled || !((GuiTimelineKey)this.control).modifiable) {
            foreground = style.disabledBackground;
        } else if (this.selected) {
            foreground = style.headerBackground;
        } else if (controlRect.inside(mouseX, mouseY)) {
            foreground = style.clickableHighlight;
        }
        foreground.render(graphics, borderWidth, borderWidth, width - borderWidth * 2, height - borderWidth * 2);
        pose.popMatrix();
    }

    @Override
    protected void renderContent(class_332 graphics, int mouseX, int mouseY) {
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

