/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_11910;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2491;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.joml.Matrix3x2fStack;
import team.creative.creativecore.CreativeCoreGuiRegistry;
import team.creative.creativecore.client.gui.GuiClientControl;
import team.creative.creativecore.client.gui.GuiClientLayer;
import team.creative.creativecore.client.gui.control.inventory.GuiClientSlot;
import team.creative.creativecore.client.gui.manager.GuiClientManager;
import team.creative.creativecore.client.render.gui.CreativeGuiGraphics;
import team.creative.creativecore.common.gui.manager.GuiManagerItem;

public class GuiClientManagerItem
extends GuiClientManager<GuiManagerItem> {
    private boolean drag;
    private boolean rightClick;
    private List<GuiClientSlot> dragged;
    private List<Integer> stackSizes;

    public static int freeSpace(class_1735 slot, class_1799 hand) {
        if (slot.method_7680(hand) && class_1703.method_7592((class_1735)slot, (class_1799)hand, (boolean)true)) {
            int stackSize = slot.method_7676(hand);
            if (slot.method_7681()) {
                stackSize -= slot.method_7677().method_7947();
            }
            return stackSize;
        }
        return -1;
    }

    public GuiClientManagerItem(GuiManagerItem manager) {
        super(manager);
    }

    public class_1799 getHand() {
        return ((GuiManagerItem)this.manager).getHand();
    }

    public void setHandChanged() {
        ((GuiManagerItem)this.manager).setHandChanged();
    }

    @Override
    public void mouseClickedOutside(double x, double y) {
        if (!((GuiManagerItem)this.manager).getHand().method_7960()) {
            CreativeCoreGuiRegistry.DROP_HAND.send(((GuiManagerItem)this.manager).layer, class_2491.field_21033);
        }
    }

    @Override
    public void mouseReleased(double x, double y, class_11910 info) {
        if (this.isDragged() && this.rightClick == (info.comp_4801() == 1)) {
            this.endDrag();
        }
    }

    @Override
    public void renderOverlay(class_332 graphics, GuiClientLayer layer, int mouseX, int mouseY) {
        class_1799 stack = ((GuiManagerItem)this.manager).getHand();
        int count = stack.method_7947();
        if (this.drag) {
            int used = 0;
            int countPerSlot = Math.max(1, class_3532.method_15375((float)((float)((GuiManagerItem)this.manager).getHand().method_7947() / (float)this.stackSizes.size())));
            if (this.rightClick) {
                countPerSlot = 1;
            }
            for (int i = 0; i < this.stackSizes.size(); ++i) {
                used += Math.min(countPerSlot, this.stackSizes.get(i));
            }
            int left = ((GuiManagerItem)this.manager).getHand().method_7947() - used;
            count = Math.max(0, left);
        }
        if (!(stack.method_7960() || this.drag && !this.rightClick && this.dragged.size() <= 1)) {
            Matrix3x2fStack pose = graphics.method_51448();
            pose.pushMatrix();
            GuiClientControl.scissor(graphics, null);
            pose.translate((float)(mouseX - 8), (float)(mouseY - 8));
            graphics.method_51427(stack, 0, 0);
            ((CreativeGuiGraphics)graphics).renderItemDecorations(stack, 0, 0, count == 1 ? null : "" + count);
            pose.popMatrix();
        }
    }

    public void startDrag(GuiClientSlot slot, boolean rightClick, int stackSize) {
        this.drag = true;
        this.dragged = new ArrayList<GuiClientSlot>();
        this.dragged.add(slot);
        this.rightClick = rightClick;
        this.stackSizes = new ArrayList<Integer>();
        this.stackSizes.add(stackSize);
        slot.draggedIndex = 0;
    }

    public void addToDrag(GuiClientSlot slot) {
        int stackSize = GuiClientManagerItem.freeSpace(slot.slot(), ((GuiManagerItem)this.manager).getHand());
        if (stackSize > 0) {
            slot.draggedIndex = this.dragged.size();
            this.dragged.add(slot);
            this.stackSizes.add(stackSize);
        }
    }

    public void modifyDrag(GuiClientSlot slot) {
        this.stackSizes.set(slot.draggedIndex, GuiClientManagerItem.freeSpace(slot.slot(), ((GuiManagerItem)this.manager).getHand()));
    }

    public void abortDrag() {
        for (GuiClientSlot slot : this.dragged) {
            slot.draggedIndex = -1;
        }
        this.drag = false;
        this.rightClick = false;
        this.dragged = null;
        this.stackSizes = null;
    }

    public void endDrag() {
        class_2487 nbt = new class_2487();
        nbt.method_10556("rightClick", this.rightClick);
        HashMap<String, Integer> inventories = new HashMap<String, Integer>();
        class_2499 names = new class_2499();
        int[] ids = new int[this.dragged.size() * 2];
        int i = 0;
        for (GuiClientSlot slot : this.dragged) {
            String inventory = slot.inventory().name();
            Integer inventoryId = (Integer)inventories.get(inventory);
            if (inventoryId == null) {
                inventoryId = inventories.size();
                inventories.put(inventory, inventoryId);
                names.add((Object)class_2519.method_23256((String)inventory));
            }
            ids[i] = inventoryId;
            ids[i + 1] = slot.slot().method_34266();
            i += 2;
        }
        nbt.method_10539("ids", ids);
        nbt.method_10566("names", (class_2520)names);
        CreativeCoreGuiRegistry.SPREAD.sendAndExecute(((GuiManagerItem)this.manager).layer, nbt);
        if (this.isDragged()) {
            this.abortDrag();
        }
    }

    public boolean isDragged() {
        return this.drag;
    }

    public void setHand(class_1799 stack) {
        ((GuiManagerItem)this.manager).setHand(stack);
    }

    public int additionalDragCount(int index) {
        if (index >= ((GuiManagerItem)this.manager).getHand().method_7947()) {
            return 0;
        }
        if (this.rightClick) {
            return 1;
        }
        return Math.max(1, class_3532.method_15375((float)((float)((GuiManagerItem)this.manager).getHand().method_7947() / (float)this.dragged.size())));
    }
}

