/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.gui;

import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1934;
import team.creative.creativecore.common.config.gui.GuiPlayerSelectorButton;
import team.creative.creativecore.common.config.gui.PlayerSelectorDialog;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiListBoxBase;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiStateButton;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.util.player.PlayerSelector;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;
import team.creative.creativecore.common.util.text.TextMapBuilder;

@Environment(value=EnvType.CLIENT)
public abstract class GuiPlayerSelectorHandler<T extends PlayerSelector> {
    public static final NamedHandlerRegistry<GuiPlayerSelectorHandler> REGISTRY = new NamedHandlerRegistry<Object>(null);

    public static GuiPlayerSelectorHandler get(PlayerSelector selector) {
        return REGISTRY.get(PlayerSelector.REGISTRY.getId(selector));
    }

    public String getName() {
        return REGISTRY.getId(this);
    }

    public abstract void createControls(GuiParent var1, PlayerSelector var2);

    public abstract T parseSelector(GuiParent var1);

    public void onChanged(PlayerSelectorDialog gui, GuiControlChangedEvent event) {
    }

    static {
        REGISTRY.register("and", new GuiPlayerSelectorHandlerMultiple<PlayerSelector.PlayerSelectorAnd>(){

            @Override
            public PlayerSelector.PlayerSelectorAnd parseSelector(PlayerSelector[] selectors) {
                return new PlayerSelector.PlayerSelectorAnd(selectors);
            }
        });
        REGISTRY.register("or", new GuiPlayerSelectorHandlerMultiple<PlayerSelector.PlayerSelectorOr>(){

            @Override
            public PlayerSelector.PlayerSelectorOr parseSelector(PlayerSelector[] selectors) {
                return new PlayerSelector.PlayerSelectorOr(selectors);
            }
        });
        REGISTRY.register("not", new GuiPlayerSelectorHandler<PlayerSelector.PlayerSelectorNot>(){

            @Override
            public void createControls(GuiParent gui, PlayerSelector selector) {
                PlayerSelector playerSelector;
                if (selector instanceof PlayerSelector.PlayerSelectorNot) {
                    PlayerSelector.PlayerSelectorNot select = (PlayerSelector.PlayerSelectorNot)selector;
                    playerSelector = select.selector;
                } else {
                    playerSelector = new PlayerSelector.PlayerSelectorLevel(0);
                }
                gui.add((GuiControl)new GuiPlayerSelectorButton((IGuiParent)gui, "not", playerSelector));
            }

            @Override
            public PlayerSelector.PlayerSelectorNot parseSelector(GuiParent gui) {
                GuiPlayerSelectorButton button = (GuiPlayerSelectorButton)gui.get("not");
                PlayerSelector selector = button.get();
                if (selector != null) {
                    return new PlayerSelector.PlayerSelectorNot(selector);
                }
                return null;
            }
        });
        REGISTRY.register("level", new GuiPlayerSelectorHandler<PlayerSelector.PlayerSelectorLevel>(){

            @Override
            public void createControls(GuiParent gui, PlayerSelector selector) {
                Object object;
                if (selector instanceof PlayerSelector.PlayerSelectorLevel) {
                    PlayerSelector.PlayerSelectorLevel select = (PlayerSelector.PlayerSelectorLevel)selector;
                    object = "" + select.permissionLevel;
                } else {
                    object = "0";
                }
                gui.add((GuiControl)new GuiTextfield(gui, "content", (String)object).setNumbersOnly());
            }

            @Override
            public PlayerSelector.PlayerSelectorLevel parseSelector(GuiParent gui) {
                GuiTextfield text = (GuiTextfield)gui.get("content");
                return new PlayerSelector.PlayerSelectorLevel(text.parseInteger());
            }
        });
        REGISTRY.register("mode", new GuiPlayerSelectorHandler<PlayerSelector.PlayerSelectorGamemode>(){

            @Override
            public void createControls(GuiParent gui, PlayerSelector selector) {
                class_1934 class_19342;
                if (selector instanceof PlayerSelector.PlayerSelectorGamemode) {
                    PlayerSelector.PlayerSelectorGamemode select = (PlayerSelector.PlayerSelectorGamemode)selector;
                    class_19342 = select.type;
                } else {
                    class_19342 = class_1934.field_9215;
                }
                gui.add((GuiControl)new GuiStateButton<class_1934>((IGuiParent)gui, "mode", class_19342, new TextMapBuilder<class_1934>().addComponent(class_1934.values(), x -> x.method_32763())));
            }

            @Override
            public PlayerSelector.PlayerSelectorGamemode parseSelector(GuiParent gui) {
                GuiStateButton mode = (GuiStateButton)gui.get("mode");
                return new PlayerSelector.PlayerSelectorGamemode((class_1934)mode.selected());
            }
        });
        REGISTRY.register("selector", new GuiPlayerSelectorHandler<PlayerSelector.PlayerSelectorCommandSelector>(){

            @Override
            public void createControls(GuiParent gui, PlayerSelector selector) {
                String string;
                if (selector instanceof PlayerSelector.PlayerSelectorCommandSelector) {
                    PlayerSelector.PlayerSelectorCommandSelector select = (PlayerSelector.PlayerSelectorCommandSelector)selector;
                    string = select.pattern;
                } else {
                    string = "@a[]";
                }
                gui.add((GuiControl)new GuiTextfield(gui, "content", string));
            }

            @Override
            public PlayerSelector.PlayerSelectorCommandSelector parseSelector(GuiParent gui) {
                GuiTextfield text = (GuiTextfield)gui.get("content");
                if (text.getText().isEmpty()) {
                    return null;
                }
                return new PlayerSelector.PlayerSelectorCommandSelector(text.getText());
            }
        });
    }

    public static abstract class GuiPlayerSelectorHandlerMultiple<T extends PlayerSelector>
    extends GuiPlayerSelectorHandler<T> {
        public PlayerSelector[] getChildren(PlayerSelector selector) {
            if (selector instanceof PlayerSelector.PlayerSelectorAnd) {
                return ((PlayerSelector.PlayerSelectorAnd)selector).selectors;
            }
            if (selector instanceof PlayerSelector.PlayerSelectorOr) {
                return ((PlayerSelector.PlayerSelectorOr)selector).selectors;
            }
            return new PlayerSelector[]{selector};
        }

        @Override
        public void createControls(GuiParent gui, PlayerSelector selector) {
            PlayerSelector[] selectors = this.getChildren(selector);
            ArrayList<GuiPlayerSelectorButton> buttons = new ArrayList<GuiPlayerSelectorButton>();
            if (selectors != null) {
                for (int i = 0; i < selectors.length; ++i) {
                    buttons.add(new GuiPlayerSelectorButton((IGuiParent)gui, "" + i, selectors[i]));
                }
            }
            GuiListBoxBase list = new GuiListBoxBase((IGuiParent)gui, "list", true, buttons);
            gui.add((GuiControl)list.setExpandable());
            gui.add((GuiControl)new GuiButton(gui, "add", x -> list.addItem(new GuiPlayerSelectorButton((IGuiParent)gui, "new", new PlayerSelector.PlayerSelectorLevel(0)))).setTranslate("gui.add"));
        }

        @Override
        public T parseSelector(GuiParent gui) {
            GuiListBoxBase list = (GuiListBoxBase)gui.get("list");
            PlayerSelector[] selectors = new PlayerSelector[list.size()];
            for (int i = 0; i < selectors.length; ++i) {
                selectors[i] = ((GuiPlayerSelectorButton)list.getItem(i)).get();
            }
            if (selectors.length > 0) {
                return this.parseSelector(selectors);
            }
            return null;
        }

        public abstract T parseSelector(PlayerSelector[] var1);
    }
}

