/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.shadows;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import net.caffeinemc.mods.sodium.client.util.SodiumChunkSection;
import net.caffeinemc.mods.sodium.client.world.LevelRendererExtension;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.compat.dh.DHCompat;
import net.irisshaders.iris.gl.GLDebug;
import net.irisshaders.iris.gl.IrisRenderSystem;
import net.irisshaders.iris.gui.option.IrisVideoSettings;
import net.irisshaders.iris.mixin.LevelRendererAccessor;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPhase;
import net.irisshaders.iris.shaderpack.programs.ProgramSource;
import net.irisshaders.iris.shaderpack.properties.PackDirectives;
import net.irisshaders.iris.shaderpack.properties.PackShadowDirectives;
import net.irisshaders.iris.shaderpack.properties.ShadowCullState;
import net.irisshaders.iris.shadows.CullingDataCache;
import net.irisshaders.iris.shadows.ShadowCompositeRenderer;
import net.irisshaders.iris.shadows.ShadowMatrices;
import net.irisshaders.iris.shadows.ShadowRenderTargets;
import net.irisshaders.iris.shadows.frustum.BoxCuller;
import net.irisshaders.iris.shadows.frustum.CullEverythingFrustum;
import net.irisshaders.iris.shadows.frustum.FrustumHolder;
import net.irisshaders.iris.shadows.frustum.advanced.AdvancedShadowCullingFrustum;
import net.irisshaders.iris.shadows.frustum.advanced.SafeZoneCullingFrustum;
import net.irisshaders.iris.shadows.frustum.fallback.BoxCullingFrustum;
import net.irisshaders.iris.shadows.frustum.fallback.NonCullingFrustum;
import net.irisshaders.iris.uniforms.CameraUniforms;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.irisshaders.iris.uniforms.CelestialUniforms;
import net.irisshaders.iris.uniforms.custom.CustomUniforms;
import net.minecraft.class_10017;
import net.minecraft.class_10209;
import net.minecraft.class_11531;
import net.minecraft.class_11532;
import net.minecraft.class_11630;
import net.minecraft.class_11658;
import net.minecraft.class_11659;
import net.minecraft.class_11661;
import net.minecraft.class_11684;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12137;
import net.minecraft.class_12206;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_4618;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_8921;
import net.minecraft.class_898;
import net.minecraft.class_9779;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ShadowRenderer {
    public static boolean ACTIVE = false;
    public static List<class_2586> visibleBlockEntities;
    public static int renderDistance;
    public static Matrix4f MODELVIEW;
    public static Matrix4f PROJECTION;
    public static class_4604 FRUSTUM;
    private final float halfPlaneLength;
    private final float nearPlane;
    private final float farPlane;
    private final float voxelDistance;
    private final float renderDistanceMultiplier;
    private final float entityShadowDistanceMultiplier;
    private final int resolution;
    private final float intervalSize;
    private final Float fov;
    private final ShadowRenderTargets targets;
    private final ShadowCullState packCullingState;
    private final ShadowCompositeRenderer compositeRenderer;
    private final boolean shouldRenderTerrain;
    private final boolean shouldRenderTranslucent;
    private final boolean shouldRenderEntities;
    private final boolean shouldRenderPlayer;
    private final boolean shouldRenderBlockEntities;
    private final boolean shouldRenderDH;
    private final float sunPathRotation;
    private final class_4599 buffers;
    private final List<MipmapPass> mipmapPasses = new ArrayList<MipmapPass>();
    private final String debugStringOverall;
    private final boolean separateHardwareSamplers;
    private final boolean shouldRenderLightBlockEntities;
    private final IrisRenderingPipeline pipeline;
    private final class_4618 outlineBuffers;
    private boolean packHasVoxelization;
    private FrustumHolder terrainFrustumHolder;
    private FrustumHolder entityFrustumHolder;
    private String debugStringTerrain = "(unavailable)";
    private int renderedShadowEntities = 0;
    private int renderedShadowBlockEntities = 0;
    private final class_11658 levelRenderState;
    private final class_11661 submitNodeStorage;
    private final class_11684 featureRenderDispatcher;

    public ShadowRenderer(IrisRenderingPipeline pipeline, ProgramSource shadow, PackDirectives directives, ShadowRenderTargets shadowRenderTargets, ShadowCompositeRenderer compositeRenderer, CustomUniforms customUniforms, boolean separateHardwareSamplers) {
        this.pipeline = pipeline;
        this.separateHardwareSamplers = separateHardwareSamplers;
        PackShadowDirectives shadowDirectives = directives.getShadowDirectives();
        this.halfPlaneLength = shadowDirectives.getDistance();
        this.nearPlane = shadowDirectives.getNearPlane();
        this.farPlane = shadowDirectives.getFarPlane();
        this.voxelDistance = shadowDirectives.getVoxelDistance();
        this.renderDistanceMultiplier = shadowDirectives.getDistanceRenderMul();
        this.entityShadowDistanceMultiplier = shadowDirectives.getEntityShadowDistanceMul();
        this.resolution = shadowDirectives.getResolution();
        this.intervalSize = shadowDirectives.getIntervalSize();
        this.shouldRenderTerrain = shadowDirectives.shouldRenderTerrain();
        this.shouldRenderTranslucent = shadowDirectives.shouldRenderTranslucent();
        this.shouldRenderEntities = shadowDirectives.shouldRenderEntities();
        this.shouldRenderPlayer = shadowDirectives.shouldRenderPlayer();
        this.shouldRenderBlockEntities = shadowDirectives.shouldRenderBlockEntities();
        this.shouldRenderLightBlockEntities = shadowDirectives.shouldRenderLightBlockEntities();
        this.shouldRenderDH = shadowDirectives.isDhShadowEnabled().orElse(false);
        this.compositeRenderer = compositeRenderer;
        this.debugStringOverall = "half plane = " + this.halfPlaneLength + " meters @ " + this.resolution + "x" + this.resolution;
        this.terrainFrustumHolder = new FrustumHolder();
        this.entityFrustumHolder = new FrustumHolder();
        this.fov = shadowDirectives.getFov();
        this.targets = shadowRenderTargets;
        if (shadow != null) {
            this.packHasVoxelization = shadow.getGeometrySource().isPresent();
            this.packCullingState = shadowDirectives.getCullingState();
        } else {
            this.packHasVoxelization = false;
            this.packCullingState = ShadowCullState.DEFAULT;
        }
        this.sunPathRotation = directives.getSunPathRotation();
        int processors = Runtime.getRuntime().availableProcessors();
        this.buffers = new class_4599(processors);
        this.outlineBuffers = new class_4618();
        this.configureSamplingSettings(shadowDirectives);
        this.levelRenderState = new class_11658();
        this.submitNodeStorage = new class_11661();
        this.featureRenderDispatcher = new class_11684(this.submitNodeStorage, class_310.method_1551().method_1541(), this.buffers.method_23000(), class_310.method_1551().method_72703(), this.outlineBuffers, this.buffers.method_23001(), class_310.method_1551().field_1772);
    }

    public static class_4587 createShadowModelView(float sunPathRotation, float intervalSize, float nearPlane, float farPlane) {
        Vector3d cameraPos = CameraUniforms.getUnshiftedCameraPosition();
        double cameraX = cameraPos.x;
        double cameraY = cameraPos.y;
        double cameraZ = cameraPos.z;
        class_4587 modelView = new class_4587();
        ShadowMatrices.createModelViewMatrix(modelView, ShadowRenderer.getShadowAngle(), intervalSize, sunPathRotation, cameraX, cameraY, cameraZ, nearPlane, farPlane);
        return modelView;
    }

    private static class_638 getLevel() {
        return Objects.requireNonNull(class_310.method_1551().field_1687);
    }

    public static float getSunAngle(boolean sun) {
        float currentAngle = ((Float)class_310.method_1551().field_1773.method_19418().method_75756().method_75689(sun ? class_12206.field_64340 : class_12206.field_64341, CapturedRenderingState.INSTANCE.getTickDelta())).floatValue();
        float c = currentAngle + 90.0f;
        if (c < 0.0f) {
            c += 360.0f;
        } else if (c > 360.0f) {
            c -= 360.0f;
        }
        return c;
    }

    private static float getShadowAngle() {
        float shadowAngle = ShadowRenderer.getSunAngle(CelestialUniforms.isDay());
        return shadowAngle / 360.0f;
    }

    public void setUsesImages(boolean usesImages) {
        this.packHasVoxelization = this.packHasVoxelization || usesImages;
    }

    private void configureSamplingSettings(PackShadowDirectives shadowDirectives) {
        ImmutableList<PackShadowDirectives.DepthSamplingSettings> depthSamplingSettings = shadowDirectives.getDepthSamplingSettings();
        Int2ObjectMap<PackShadowDirectives.SamplingSettings> colorSamplingSettings = shadowDirectives.getColorSamplingSettings();
        GlStateManager._activeTexture((int)33988);
        this.configureDepthSampler(this.targets.getDepthTexture().iris$getGlId(), (PackShadowDirectives.DepthSamplingSettings)depthSamplingSettings.get(0));
        this.configureDepthSampler(this.targets.getDepthTextureNoTranslucents().iris$getGlId(), (PackShadowDirectives.DepthSamplingSettings)depthSamplingSettings.get(1));
        for (int i = 0; i < this.targets.getNumColorTextures(); ++i) {
            if (this.targets.get(i) == null) continue;
            int glTextureId = this.targets.get(i).getMainTexture();
            this.configureSampler(glTextureId, (PackShadowDirectives.SamplingSettings)colorSamplingSettings.computeIfAbsent(i, a -> new PackShadowDirectives.SamplingSettings()));
        }
        GlStateManager._activeTexture((int)33984);
    }

    private void configureDepthSampler(int glTextureId, PackShadowDirectives.DepthSamplingSettings settings) {
        if (settings.getHardwareFiltering() && !this.separateHardwareSamplers) {
            IrisRenderSystem.texParameteri(glTextureId, 3553, 34892, 34894);
        }
        IrisRenderSystem.texParameteriv(glTextureId, 3553, 36422, new int[]{6403, 6403, 6403, 1});
        this.configureSampler(glTextureId, settings);
    }

    private void configureSampler(int glTextureId, PackShadowDirectives.SamplingSettings settings) {
        if (settings.getMipmap()) {
            int filteringMode = settings.getNearest() ? 9984 : 9987;
            this.mipmapPasses.add(new MipmapPass(glTextureId, filteringMode));
        }
        if (!settings.getNearest()) {
            IrisRenderSystem.texParameteri(glTextureId, 3553, 10241, 9729);
            IrisRenderSystem.texParameteri(glTextureId, 3553, 10240, 9729);
        } else {
            IrisRenderSystem.texParameteri(glTextureId, 3553, 10241, 9728);
            IrisRenderSystem.texParameteri(glTextureId, 3553, 10240, 9728);
        }
    }

    private void generateMipmaps() {
        GlStateManager._activeTexture((int)33988);
        for (MipmapPass mipmapPass : this.mipmapPasses) {
            this.setupMipmappingForTexture(mipmapPass.texture(), mipmapPass.targetFilteringMode());
        }
        GlStateManager._activeTexture((int)33984);
    }

    private void setupMipmappingForTexture(int texture, int filteringMode) {
        IrisRenderSystem.generateMipmaps(texture, 3553);
        IrisRenderSystem.texParameteri(texture, 3553, 10241, filteringMode);
    }

    private FrustumHolder createShadowFrustum(float renderMultiplier, FrustumHolder holder) {
        String reason;
        double distance;
        if (this.packCullingState == ShadowCullState.DEFAULT && this.packHasVoxelization || this.packCullingState == ShadowCullState.DISTANCE) {
            distance = this.halfPlaneLength * renderMultiplier;
            reason = this.packCullingState == ShadowCullState.DISTANCE ? "(set by shader pack)" : "(voxelization detected)";
            if (distance <= 0.0 || distance > (double)(class_310.method_1551().field_1690.method_38521() * 16)) {
                String distanceInfo = "render distance = " + class_310.method_1551().field_1690.method_38521() * 16 + " blocks ";
                distanceInfo = distanceInfo + (class_310.method_1551().method_1542() ? "(capped by normal render distance)" : "(capped by normal/server render distance)");
                String cullingInfo = "disabled " + reason;
                return holder.setInfo(new NonCullingFrustum(), distanceInfo, cullingInfo);
            }
        } else {
            Object cullingInfo;
            BoxCuller boxCuller;
            String distanceInfo;
            boolean hasSafeZone;
            boolean bl = hasSafeZone = this.packCullingState == ShadowCullState.SAFE_ZONE;
            if (hasSafeZone && renderMultiplier < 0.0f) {
                renderMultiplier = 1.0f;
            }
            double distance2 = (hasSafeZone ? this.voxelDistance : this.halfPlaneLength) * renderMultiplier;
            String setter = "(set by shader pack)";
            if (renderMultiplier < 0.0f) {
                distance2 = IrisVideoSettings.shadowDistance * 16;
                setter = "(set by user)";
            }
            if (distance2 >= (double)(class_310.method_1551().field_1690.method_38521() * 16) && !hasSafeZone) {
                distanceInfo = "render distance = " + class_310.method_1551().field_1690.method_38521() * 16 + " blocks ";
                distanceInfo = (String)distanceInfo + (class_310.method_1551().method_1542() ? "(capped by normal render distance)" : "(capped by normal/server render distance)");
                boxCuller = null;
            } else {
                distanceInfo = distance2 + " blocks " + setter;
                if (distance2 == 0.0 && !hasSafeZone) {
                    cullingInfo = "no shadows rendered";
                    holder.setInfo(new CullEverythingFrustum(), distanceInfo, (String)cullingInfo);
                }
                boxCuller = new BoxCuller(distance2);
            }
            cullingInfo = (hasSafeZone ? "Safe Zone" : "Advanced") + " Frustum Culling enabled";
            Vector4f shadowLightPosition = new CelestialUniforms(this.sunPathRotation).getShadowLightPositionInWorldSpace();
            Vector3f shadowLightVectorFromOrigin = new Vector3f(shadowLightPosition.x(), shadowLightPosition.y(), shadowLightPosition.z());
            shadowLightVectorFromOrigin.normalize();
            Matrix4f projView = (this.shouldRenderDH && DHCompat.hasRenderingEnabled() ? DHCompat.getProjection() : CapturedRenderingState.INSTANCE.getGbufferProjection()).mul(CapturedRenderingState.INSTANCE.getGbufferModelView(), new Matrix4f());
            if (hasSafeZone) {
                return holder.setInfo(new SafeZoneCullingFrustum((Matrix4fc)projView, (Matrix4fc)PROJECTION, shadowLightVectorFromOrigin, boxCuller, new BoxCuller(this.halfPlaneLength * renderMultiplier)), distanceInfo, (String)cullingInfo);
            }
            return holder.setInfo(new AdvancedShadowCullingFrustum((Matrix4fc)projView, (Matrix4fc)PROJECTION, shadowLightVectorFromOrigin, boxCuller), distanceInfo, (String)cullingInfo);
        }
        String distanceInfo = distance + " blocks (set by shader pack)";
        String cullingInfo = "distance only " + reason;
        BoxCuller boxCuller = new BoxCuller(distance);
        holder.setInfo(new BoxCullingFrustum(boxCuller), distanceInfo, cullingInfo);
        return holder;
    }

    public void setupShadowViewport() {
        GlStateManager._viewport((int)0, (int)0, (int)this.resolution, (int)this.resolution);
    }

    public void renderShadows(LevelRendererAccessor levelRenderer, class_4184 playerCamera, class_12075 renderState) {
        if (IrisVideoSettings.getOverriddenShadowDistance(IrisVideoSettings.shadowDistance) == 0) {
            return;
        }
        class_12137 theSampler = RenderSystem.getSamplerCache().method_75293(AddressMode.CLAMP_TO_EDGE, AddressMode.CLAMP_TO_EDGE, FilterMode.NEAREST, FilterMode.NEAREST, true);
        this.levelRenderState.field_63082.field_63077 = renderState.field_63077;
        this.levelRenderState.field_63082.field_63078 = renderState.field_63078;
        this.levelRenderState.field_63082.field_63081 = renderState.field_63081;
        this.levelRenderState.field_63082.field_63080 = renderState.field_63080;
        this.levelRenderState.field_63082.field_63079 = renderState.field_63079;
        class_310 client = class_310.method_1551();
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15405("shadows");
        ACTIVE = true;
        renderDistance = (int)(this.halfPlaneLength * this.renderDistanceMultiplier / 16.0f);
        if (this.renderDistanceMultiplier < 0.0f) {
            renderDistance = IrisVideoSettings.shadowDistance;
        }
        visibleBlockEntities = new ArrayList<class_2586>();
        class_4599 playerBuffers = levelRenderer.getRenderBuffers();
        levelRenderer.setRenderBuffers(this.buffers);
        visibleBlockEntities = new ArrayList<class_2586>();
        this.setupShadowViewport();
        class_4587 modelView = ShadowRenderer.createShadowModelView(this.sunPathRotation, this.intervalSize, this.nearPlane, this.farPlane);
        MODELVIEW = new Matrix4f((Matrix4fc)modelView.method_23760().method_23761());
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().set((Matrix4fc)MODELVIEW);
        Matrix4f shadowProjection = this.fov != null ? ShadowMatrices.createPerspectiveMatrix(this.fov.floatValue()) : ShadowMatrices.createOrthoMatrix(this.halfPlaneLength, class_3532.method_15347((float)this.nearPlane, (float)-1.0f) ? (float)(-DHCompat.getRenderDistance() * 16) : this.nearPlane, class_3532.method_15347((float)this.farPlane, (float)-1.0f) ? (float)(DHCompat.getRenderDistance() * 16) : this.farPlane);
        IrisRenderSystem.setShadowProjection(shadowProjection);
        PROJECTION = shadowProjection;
        profiler.method_15396("terrain_setup");
        if (levelRenderer instanceof CullingDataCache) {
            ((CullingDataCache)((Object)levelRenderer)).saveState();
        }
        profiler.method_15396("initialize frustum");
        this.terrainFrustumHolder = this.createShadowFrustum(this.renderDistanceMultiplier, this.terrainFrustumHolder);
        FRUSTUM = this.terrainFrustumHolder.getFrustum();
        Vector3d cameraPos = CameraUniforms.getUnshiftedCameraPosition();
        double cameraX = cameraPos.x();
        double cameraY = cameraPos.y();
        double cameraZ = cameraPos.z();
        this.terrainFrustumHolder.getFrustum().method_23088(cameraX, cameraY, cameraZ);
        profiler.method_15407();
        boolean wasChunkCullingEnabled = client.field_1730;
        client.field_1730 = false;
        ChunkRenderMatrices playerMatrices = ((LevelRendererExtension)levelRenderer).sodium$getMatrices();
        ((LevelRendererExtension)levelRenderer).sodium$setMatrices(new ChunkRenderMatrices((Matrix4fc)shadowProjection, (Matrix4fc)MODELVIEW));
        ((class_761)levelRenderer).method_3292();
        levelRenderer.invokeCullTerrain(playerCamera, this.terrainFrustumHolder.getFrustum(), false);
        client.field_1730 = wasChunkCullingEnabled;
        profiler.method_15405("terrain");
        GlStateManager._disableCull();
        class_11532 sections = new class_11532(null, null, 0, null);
        ((SodiumChunkSection)sections).sodium$setRendering(((LevelRendererExtension)levelRenderer).sodium$getWorldRenderer(), ((LevelRendererExtension)levelRenderer).sodium$getMatrices(), cameraX, cameraY, cameraZ);
        if (this.shouldRenderTerrain) {
            this.pipeline.setPhase(WorldRenderingPhase.TERRAIN_SOLID);
            sections.method_72170(class_11531.field_61022, theSampler);
            this.pipeline.setPhase(WorldRenderingPhase.NONE);
        }
        this.pipeline.setPhase(WorldRenderingPhase.ENTITIES);
        GlStateManager._viewport((int)0, (int)0, (int)this.resolution, (int)this.resolution);
        profiler.method_15405("entities");
        float tickDelta = CapturedRenderingState.INSTANCE.getTickDelta();
        boolean hasEntityFrustum = false;
        if (this.entityShadowDistanceMultiplier == 1.0f || this.entityShadowDistanceMultiplier < 0.0f) {
            this.entityFrustumHolder.setInfo(this.terrainFrustumHolder.getFrustum(), this.terrainFrustumHolder.getDistanceInfo(), this.terrainFrustumHolder.getCullingInfo());
        } else {
            hasEntityFrustum = true;
            this.entityFrustumHolder = this.createShadowFrustum(this.renderDistanceMultiplier * this.entityShadowDistanceMultiplier, this.entityFrustumHolder);
        }
        class_4604 entityShadowFrustum = this.entityFrustumHolder.getFrustum();
        entityShadowFrustum.method_23088(cameraX, cameraY, cameraZ);
        this.levelRenderState.method_72913();
        if (this.shouldRenderEntities) {
            this.extractVisibleEntities(playerCamera, this.entityFrustumHolder.getFrustum(), class_310.method_1551().method_61966(), this.levelRenderState);
        } else if (this.shouldRenderPlayer) {
            class_746 player = class_310.method_1551().field_1724;
            float g = class_310.method_1551().method_61966().method_60637(false);
            this.levelRenderState.field_61735.add(class_310.method_1551().method_1561().method_72977((class_1297)player, g));
            if (player.method_5854() != null) {
                this.levelRenderState.field_61735.add(class_310.method_1551().method_1561().method_72977(player.method_5854(), g));
            }
        }
        class_4597.class_4598 bufferSource = this.buffers.method_23000();
        class_898 dispatcher = levelRenderer.getEntityRenderDispatcher();
        RenderSystem.getModelViewStack().identity();
        this.renderedShadowEntities = this.renderEntities(levelRenderer, dispatcher, bufferSource, modelView, tickDelta, entityShadowFrustum, cameraX, cameraY, cameraZ);
        profiler.method_15405("build blockentities");
        if (this.shouldRenderBlockEntities || this.shouldRenderLightBlockEntities) {
            this.extractVisibleBlockEntities(levelRenderer, bufferSource, modelView, tickDelta, playerCamera, this.levelRenderState, !this.shouldRenderBlockEntities && this.shouldRenderLightBlockEntities);
        }
        this.renderedShadowBlockEntities = this.renderBlockEntities(levelRenderer, modelView, this.submitNodeStorage, this.levelRenderState, playerCamera);
        profiler.method_15405("draw entities");
        this.featureRenderDispatcher.method_73002();
        bufferSource.method_22993();
        this.copyPreTranslucentDepth(levelRenderer);
        RenderSystem.getModelViewStack().set((Matrix4fc)MODELVIEW);
        profiler.method_15405("translucent terrain");
        this.pipeline.setPhase(WorldRenderingPhase.NONE);
        if (this.shouldRenderTranslucent) {
            this.pipeline.setPhase(WorldRenderingPhase.TERRAIN_TRANSLUCENT);
            sections.method_72170(class_11531.field_61023, theSampler);
            this.pipeline.setPhase(WorldRenderingPhase.NONE);
        }
        IrisRenderSystem.restorePlayerProjection();
        this.debugStringTerrain = ((class_761)levelRenderer).method_3289();
        profiler.method_15405("generate mipmaps");
        this.generateMipmaps();
        profiler.method_15405("restore gl state");
        GlStateManager._enableCull();
        ((LevelRendererExtension)levelRenderer).sodium$setMatrices(playerMatrices);
        GlStateManager._viewport((int)0, (int)0, (int)client.method_1522().field_1482, (int)client.method_1522().field_1481);
        if (levelRenderer instanceof CullingDataCache) {
            ((CullingDataCache)((Object)levelRenderer)).restoreState();
        }
        this.pipeline.removePhaseIfNeeded();
        GLDebug.pushGroup(901, "shadowcomp");
        this.compositeRenderer.renderAll();
        GLDebug.popGroup();
        levelRenderer.setRenderBuffers(playerBuffers);
        visibleBlockEntities = null;
        ACTIVE = false;
        RenderSystem.getModelViewStack().popMatrix();
        profiler.method_15407();
        profiler.method_15405("updatechunks");
    }

    private int renderBlockEntities(LevelRendererAccessor levelRenderer, class_4587 modelView, class_11661 submitNodeStorage, class_11658 levelRenderState, class_4184 camera) {
        class_243 vec3 = camera.method_71156();
        class_4587 poseStack = modelView;
        double d = vec3.method_10216();
        double e = vec3.method_10214();
        double f = vec3.method_10215();
        int i = 0;
        for (class_11954 blockEntityRenderState : levelRenderState.field_62646) {
            class_2338 blockPos = blockEntityRenderState.field_62673;
            poseStack.method_22903();
            poseStack.method_22904((double)blockPos.method_10263() - d, (double)blockPos.method_10264() - e, (double)blockPos.method_10260() - f);
            class_310.method_1551().method_31975().method_3555(blockEntityRenderState, poseStack, (class_11659)submitNodeStorage, levelRenderState.field_63082);
            poseStack.method_22909();
            ++i;
        }
        return i;
    }

    private void extractVisibleBlockEntities(LevelRendererAccessor accessor, class_4597.class_4598 bufferSource, class_4587 modelView, float tickDelta, class_4184 camera, class_11658 levelRenderState, boolean lightsOnly) {
        accessor.invokeExtractBlockEntities(camera, tickDelta, levelRenderState);
        if (lightsOnly) {
            Iterator state = levelRenderState.field_62646.iterator();
            while (state.hasNext()) {
                class_11954 blockEntityRenderState = (class_11954)state.next();
                if (blockEntityRenderState.field_62674.method_26213() != 0) continue;
                state.remove();
            }
        }
    }

    private int renderEntities(LevelRendererAccessor levelRenderer, class_898 dispatcher, class_4597.class_4598 bufferSource, class_4587 modelView, float tickDelta, class_4604 frustum, double cameraX, double cameraY, double cameraZ) {
        class_10209.method_64146().method_15396("cull");
        for (class_10017 entityRenderState : this.levelRenderState.field_61735) {
            class_310.method_1551().method_1561().method_72976(entityRenderState, this.levelRenderState.field_63082, entityRenderState.field_53325 - cameraX, entityRenderState.field_53326 - cameraY, entityRenderState.field_53327 - cameraZ, modelView, (class_11659)this.submitNodeStorage);
        }
        class_10209.method_64146().method_15407();
        return this.levelRenderState.field_61735.size();
    }

    private void extractVisibleEntities(class_4184 camera, class_4604 frustum, class_9779 deltaTracker, class_11658 levelRenderState) {
        class_243 vec3 = camera.method_71156();
        double d = vec3.method_10216();
        double e = vec3.method_10214();
        double f = vec3.method_10215();
        class_8921 tickRateManager = class_310.method_1551().field_1687.method_54719();
        class_1297.method_5840((double)(class_3532.method_15350((double)((double)class_310.method_1551().field_1690.method_38521() / 8.0), (double)1.0, (double)2.5) * (Double)class_310.method_1551().field_1690.method_42517().method_41753()));
        for (class_1297 entity : class_310.method_1551().field_1687.method_18112()) {
            class_2338 blockPos;
            if (!class_310.method_1551().method_1561().method_3950(entity, frustum, d, e, f) && !entity.method_5821((class_1297)class_310.method_1551().field_1724) || !class_310.method_1551().field_1687.method_31601((blockPos = entity.method_24515()).method_10264()) && !class_310.method_1551().field_1769.method_40050(blockPos)) continue;
            if (entity.field_6012 == 0) {
                entity.field_6038 = entity.method_23317();
                entity.field_5971 = entity.method_23318();
                entity.field_5989 = entity.method_23321();
            }
            float g = deltaTracker.method_60637(!tickRateManager.method_54746(entity));
            class_10017 entityRenderState = class_310.method_1551().method_1561().method_72977(entity, g);
            levelRenderState.field_61735.add(entityRenderState);
        }
    }

    private int renderPlayerEntity(LevelRendererAccessor levelRenderer, class_898 dispatcher, class_4597.class_4598 bufferSource, class_4587 modelView, float tickDelta, class_4604 frustum, double cameraX, double cameraY, double cameraZ) {
        class_10209.method_64146().method_15396("cull");
        class_746 player = class_310.method_1551().field_1724;
        int shadowEntities = 0;
        if (!dispatcher.method_3950((class_1297)player, frustum, cameraX, cameraY, cameraZ) || player.method_7325()) {
            class_10209.method_64146().method_15407();
            return 0;
        }
        class_10209.method_64146().method_15405("build geometry");
        if (!player.method_5685().isEmpty()) {
            for (int i = 0; i < player.method_5685().size(); ++i) {
                float realTickDelta = class_310.method_1551().field_1687.method_54719().method_54746((class_1297)player.method_5685().get(i)) ? tickDelta : CapturedRenderingState.INSTANCE.getRealTickDelta();
                ++shadowEntities;
            }
        }
        if (player.method_5854() != null) {
            float realTickDelta = class_310.method_1551().field_1687.method_54719().method_54746(player.method_5854()) ? tickDelta : CapturedRenderingState.INSTANCE.getRealTickDelta();
            ++shadowEntities;
        }
        float realTickDelta = class_310.method_1551().field_1687.method_54719().method_54746((class_1297)player) ? tickDelta : CapturedRenderingState.INSTANCE.getRealTickDelta();
        class_10209.method_64146().method_15407();
        return ++shadowEntities;
    }

    private void copyPreTranslucentDepth(LevelRendererAccessor levelRenderer) {
        class_10209.method_64146().method_15405("translucent depth copy");
        this.targets.copyPreTranslucentDepth();
    }

    public void addDebugText(class_11630 messages) {
        if (IrisVideoSettings.getOverriddenShadowDistance(IrisVideoSettings.shadowDistance) == 0) {
            messages.method_72747("[Iris] Shadow Maps: off, shadow distance 0");
            return;
        }
        if (Iris.getIrisConfig().areDebugOptionsEnabled()) {
            messages.method_72747("[Iris] Shadow Maps: " + this.debugStringOverall);
            messages.method_72747("[Iris] Shadow Distance Terrain: " + this.terrainFrustumHolder.getDistanceInfo() + " Entity: " + this.entityFrustumHolder.getDistanceInfo());
            messages.method_72747("[Iris] Shadow Culling Terrain: " + this.terrainFrustumHolder.getCullingInfo() + " Entity: " + this.entityFrustumHolder.getCullingInfo());
            messages.method_72747("[Iris] Shadow Projection: " + this.getProjectionInfo());
            messages.method_72747("[Iris] Shadow Terrain: " + this.debugStringTerrain + (this.shouldRenderTerrain ? "" : " (no terrain) ") + (this.shouldRenderTranslucent ? "" : "(no translucent)"));
            messages.method_72747("[Iris] Shadow Entities: " + this.getEntitiesDebugString());
            messages.method_72747("[Iris] Shadow Block Entities: " + this.getBlockEntitiesDebugString());
        } else {
            messages.method_72747("[Iris] Shadow info: " + this.debugStringTerrain);
            messages.method_72747("[Iris] E: " + this.renderedShadowEntities);
            messages.method_72747("[Iris] BE: " + this.renderedShadowBlockEntities);
        }
    }

    private String getProjectionInfo() {
        return "Near: " + this.nearPlane + " Far: " + this.farPlane + " distance " + this.halfPlaneLength;
    }

    private String getEntitiesDebugString() {
        return this.shouldRenderEntities || this.shouldRenderPlayer ? this.renderedShadowEntities + "/" + (class_310.method_1551().field_1687 == null ? 0 : class_310.method_1551().field_1687.method_18120()) : "disabled by pack";
    }

    private String getBlockEntitiesDebugString() {
        return this.shouldRenderBlockEntities || this.shouldRenderLightBlockEntities ? "" + this.renderedShadowBlockEntities : "disabled by pack";
    }

    public void destroy() {
    }

    private record MipmapPass(int texture, int targetFilteringMode) {
    }
}

