/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.model;

import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.client.model.quad.ModelQuadView;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFlags;
import net.caffeinemc.mods.sodium.client.render.helper.ColorHelper;
import net.caffeinemc.mods.sodium.client.render.helper.GeometryHelper;
import net.caffeinemc.mods.sodium.client.render.helper.NormalHelper;
import net.caffeinemc.mods.sodium.client.render.model.EncodingFormat;
import net.caffeinemc.mods.sodium.client.render.model.SodiumQuadAtlas;
import net.caffeinemc.mods.sodium.client.render.model.SodiumShadeMode;
import net.minecraft.class_1058;
import net.minecraft.class_11515;
import net.minecraft.class_2350;
import net.minecraft.class_9851;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class QuadViewImpl
implements ModelQuadView {
    @Nullable
    protected class_2350 nominalFace;
    protected boolean isGeometryInvalid = true;
    protected final Vector3f faceNormal = new Vector3f();
    public int[] data;
    public int baseIndex = 0;

    public void load() {
        this.isGeometryInvalid = false;
        this.nominalFace = this.getLightFace();
        NormI8.unpack(this.packedFaceNormal(), this.faceNormal);
    }

    protected void computeGeometry() {
        if (this.isGeometryInvalid) {
            int packedFaceNormal;
            this.isGeometryInvalid = false;
            NormalHelper.computeFaceNormal(this.faceNormal, this);
            this.data[this.baseIndex + 1] = packedFaceNormal = NormI8.pack((Vector3fc)this.faceNormal);
            class_2350 lightFace = GeometryHelper.lightFace(this);
            this.data[this.baseIndex + 0] = EncodingFormat.lightFace(this.data[this.baseIndex + 0], lightFace);
            this.data[this.baseIndex + 0] = EncodingFormat.normalFace(this.data[this.baseIndex + 0], ModelQuadFacing.fromPackedNormal(packedFaceNormal));
            this.data[this.baseIndex + 0] = EncodingFormat.geometryFlags(this.data[this.baseIndex + 0], ModelQuadFlags.getQuadFlags(this, lightFace));
        }
    }

    public int geometryFlags() {
        this.computeGeometry();
        return EncodingFormat.geometryFlags(this.data[this.baseIndex + 0]);
    }

    public boolean hasShade() {
        return this.diffuseShade();
    }

    public Vector3f copyPos(int vertexIndex, @Nullable Vector3f target) {
        if (target == null) {
            target = new Vector3f();
        }
        int index = this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_X;
        target.set(Float.intBitsToFloat(this.data[index]), Float.intBitsToFloat(this.data[index + 1]), Float.intBitsToFloat(this.data[index + 2]));
        return target;
    }

    @Nullable
    public class_11515 getRenderType() {
        return EncodingFormat.renderLayer(this.data[this.baseIndex + 0]);
    }

    public boolean emissive() {
        return EncodingFormat.emissive(this.data[this.baseIndex + 0]);
    }

    public boolean diffuseShade() {
        return EncodingFormat.diffuseShade(this.data[this.baseIndex + 0]);
    }

    public class_9851 ambientOcclusion() {
        return EncodingFormat.ambientOcclusion(this.data[this.baseIndex + 0]);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable class_10444.class_10445 glint() {
        return EncodingFormat.glint(this.data[this.baseIndex + 0]);
    }

    public SodiumShadeMode getShadeMode() {
        return EncodingFormat.shadeMode(this.data[this.baseIndex + 0]);
    }

    public int baseColor(int vertexIndex) {
        return this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_COLOR];
    }

    public Vector2f copyUv(int vertexIndex, @Nullable Vector2f target) {
        if (target == null) {
            target = new Vector2f();
        }
        int index = this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_U;
        target.set(Float.intBitsToFloat(this.data[index]), Float.intBitsToFloat(this.data[index + 1]));
        return target;
    }

    public int normalFlags() {
        return EncodingFormat.normalFlags(this.data[this.baseIndex + 0]);
    }

    public boolean hasNormal(int vertexIndex) {
        return (this.normalFlags() & 1 << vertexIndex) != 0;
    }

    public boolean hasVertexNormals() {
        return this.normalFlags() != 0;
    }

    public boolean hasAllVertexNormals() {
        return (this.normalFlags() & 0xF) == 15;
    }

    protected final int normalIndex(int vertexIndex) {
        return this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_NORMAL;
    }

    public int packedNormal(int vertexIndex) {
        return this.data[this.normalIndex(vertexIndex)];
    }

    public float normalX(int vertexIndex) {
        return this.hasNormal(vertexIndex) ? NormI8.unpackX(this.data[this.normalIndex(vertexIndex)]) : Float.NaN;
    }

    public float normalY(int vertexIndex) {
        return this.hasNormal(vertexIndex) ? NormI8.unpackY(this.data[this.normalIndex(vertexIndex)]) : Float.NaN;
    }

    public float normalZ(int vertexIndex) {
        return this.hasNormal(vertexIndex) ? NormI8.unpackZ(this.data[this.normalIndex(vertexIndex)]) : Float.NaN;
    }

    @Nullable
    public Vector3f copyNormal(int vertexIndex, @Nullable Vector3f target) {
        if (this.hasNormal(vertexIndex)) {
            if (target == null) {
                target = new Vector3f();
            }
            int normal = this.data[this.normalIndex(vertexIndex)];
            NormI8.unpack(normal, target);
            return target;
        }
        return null;
    }

    @Nullable
    public final class_2350 getCullFace() {
        return EncodingFormat.cullFace(this.data[this.baseIndex + 0]);
    }

    public final ModelQuadFacing normalFace() {
        this.computeGeometry();
        return EncodingFormat.normalFace(this.data[this.baseIndex + 0]);
    }

    @Nullable
    public final class_2350 getNominalFace() {
        return this.nominalFace;
    }

    public final int packedFaceNormal() {
        this.computeGeometry();
        return this.data[this.baseIndex + 1];
    }

    public final Vector3f faceNormal() {
        this.computeGeometry();
        return this.faceNormal;
    }

    public final int getTag() {
        return this.data[this.baseIndex + 3];
    }

    public final void toVanilla(int[] target, int targetIndex) {
        System.arraycopy(this.data, this.baseIndex + 4, target, targetIndex, EncodingFormat.QUAD_STRIDE);
        int colorIndex = targetIndex + 3;
        for (int i = 0; i < 4; ++i) {
            target[colorIndex] = ColorHelper.toVanillaColor(target[colorIndex]);
            colorIndex += EncodingFormat.VANILLA_VERTEX_STRIDE;
        }
    }

    @Override
    public float getX(int idx) {
        return Float.intBitsToFloat(this.data[this.baseIndex + idx * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_X]);
    }

    @Override
    public float getY(int idx) {
        return Float.intBitsToFloat(this.data[this.baseIndex + idx * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_Y]);
    }

    @Override
    public float getZ(int idx) {
        return Float.intBitsToFloat(this.data[this.baseIndex + idx * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_Z]);
    }

    public float posByIndex(int vertexIndex, int coordinateIndex) {
        return Float.intBitsToFloat(this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + (EncodingFormat.VERTEX_X + coordinateIndex)]);
    }

    @Override
    public int getColor(int idx) {
        return ColorHelper.toVanillaColor(this.baseColor(idx));
    }

    @Override
    public float getTexU(int idx) {
        return Float.intBitsToFloat(this.data[this.baseIndex + idx * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_U]);
    }

    @Override
    public float getTexV(int idx) {
        return Float.intBitsToFloat(this.data[this.baseIndex + idx * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_V]);
    }

    @Override
    public int getVertexNormal(int idx) {
        return this.data[this.normalIndex(idx)];
    }

    @Override
    public int getFaceNormal() {
        return this.packedFaceNormal();
    }

    @Override
    public int getLight(int idx) {
        return this.data[this.baseIndex + idx * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_LIGHTMAP];
    }

    @Override
    public int getTintIndex() {
        return this.data[this.baseIndex + 2];
    }

    @Override
    public class_1058 getSprite() {
        throw new UnsupportedOperationException("Not available for QuadViewImpl.");
    }

    @Override
    public class_2350 getLightFace() {
        this.computeGeometry();
        return EncodingFormat.lightFace(this.data[this.baseIndex + 0]);
    }

    @Override
    public int getMaxLightQuad(int idx) {
        return this.getLight(idx);
    }

    @Override
    public int getFlags() {
        return this.geometryFlags();
    }

    public SodiumQuadAtlas getQuadAtlas() {
        return EncodingFormat.quadAtlas(this.data[this.baseIndex + 0]);
    }
}

